% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solr_all.r
\name{solr_all}
\alias{solr_all}
\title{All purpose search}
\usage{
solr_all(name = NULL, q = "*:*", sort = NULL, start = 0, rows = NULL,
  pageDoc = NULL, pageScore = NULL, fq = NULL, fl = NULL,
  defType = NULL, timeAllowed = NULL, qt = NULL, wt = "json",
  NOW = NULL, TZ = NULL, echoHandler = NULL, echoParams = NULL,
  key = NULL, callopts = list(), raw = FALSE, parsetype = "df",
  concat = ",", ...)
}
\arguments{
\item{name}{Name of a collection or core. Or leave as \code{NULL} if not needed.}

\item{q}{Query terms, defaults to '*:*', or everything.}

\item{sort}{Field to sort on. You can specify ascending (e.g., score desc) or 
descending (e.g., score asc), sort by two fields (e.g., score desc, price asc), 
or sort by a function (e.g., sum(x_f, y_f) desc, which sorts by the sum of 
x_f and y_f in a descending order).}

\item{start}{Record to start at, default to beginning.}

\item{rows}{Number of records to return. Default: 10.}

\item{pageDoc}{If you expect to be paging deeply into the results (say beyond page 10, 
assuming rows=10) and you are sorting by score, you may wish to add the pageDoc 
and pageScore parameters to your request. These two parameters tell Solr (and Lucene) 
what the last result (Lucene internal docid and score) of the previous page was, 
so that when scoring the query for the next set of pages, it can ignore any results 
that occur higher than that item. To get the Lucene internal doc id, you will need 
to add [docid] to the &fl list. 
e.g., q=*:*&start=10&pageDoc=5&pageScore=1.345&fl=[docid],score}

\item{pageScore}{See pageDoc notes.}

\item{fq}{Filter query, this does not affect the search, only what gets returned. 
This parameter can accept multiple items in a lis or vector. You can't pass more than 
one parameter of the same name, so we get around it by passing multiple queries 
and we parse internally}

\item{fl}{Fields to return, can be a character vector like \code{c('id', 'title')}, 
or a single character vector with one or more comma separated names, like 
\code{'id,title'}}

\item{defType}{Specify the query parser to use with this request.}

\item{timeAllowed}{The time allowed for a search to finish. This value only applies 
to the search and not to requests in general. Time is in milliseconds. Values <= 0 
mean no time restriction. Partial results may be returned (if there are any).}

\item{qt}{Which query handler used. Options: dismax, others?}

\item{wt}{(character) One of json (default) or xml. If json, uses
\code{\link[jsonlite]{fromJSON}} to parse. If xml, uses \code{\link[xml2]{read_xml}}
to parse. You can't use \code{csv} because the point of this function}

\item{NOW}{Set a fixed time for evaluating Date based expresions}

\item{TZ}{Time zone, you can override the default.}

\item{echoHandler}{If \code{TRUE}, Solr places the name of the handle used in the 
response to the client for debugging purposes. Default:}

\item{echoParams}{The echoParams parameter tells Solr what kinds of Request 
parameters should be included in the response for debugging purposes, legal values 
include:
\itemize{
 \item none - don't include any request parameters for debugging
 \item explicit - include the parameters explicitly specified by the client in the request
 \item all - include all parameters involved in this request, either specified explicitly 
 by the client, or implicit because of the request handler configuration.
}}

\item{key}{API key, if needed.}

\item{callopts}{Call options passed on to httr::GET}

\item{raw}{(logical) If TRUE, returns raw data in format specified by wt param}

\item{parsetype}{(character) One of 'list' or 'df'}

\item{concat}{(character) Character to concatenate elements of longer than length 1. 
Note that this only works reliably when data format is json (wt='json'). The parsing
is more complicated in XML format, but you can do that on your own.}

\item{...}{Further args.}
}
\value{
XML, JSON, a list, or data.frame
}
\description{
Includes documents, facets, groups, mlt, stats, and highlights.
}
\examples{
\dontrun{
# connect
solr_connect('http://api.plos.org/search')

solr_all(q='*:*', rows=2, fl='id')

# facets
solr_all(q='*:*', rows=2, fl='id', facet="true", facet.field="journal")

# mlt
solr_all(q='ecology', rows=2, fl='id', mlt='true', mlt.count=2, mlt.fl='abstract')

# facets and mlt
solr_all(q='ecology', rows=2, fl='id', facet="true", facet.field="journal",
mlt='true', mlt.count=2, mlt.fl='abstract')

# stats
solr_all(q='ecology', rows=2, fl='id', stats='true', stats.field='counter_total_all')

# facets, mlt, and stats
solr_all(q='ecology', rows=2, fl='id', facet="true", facet.field="journal",
mlt='true', mlt.count=2, mlt.fl='abstract', stats='true', stats.field='counter_total_all')

# group
solr_all(q='ecology', rows=2, fl='id', group='true',
   group.field='journal', group.limit=3)

# facets, mlt, stats, and groups
solr_all(q='ecology', rows=2, fl='id', facet="true", facet.field="journal",
   mlt='true', mlt.count=2, mlt.fl='abstract', stats='true', stats.field='counter_total_all',
   group='true', group.field='journal', group.limit=3)

# using wt = xml
solr_all(q='*:*', rows=50, fl=c('id','score'), fq='doc_type:full', wt="xml", raw=TRUE)
}
}
\references{
See \url{http://wiki.apache.org/solr/#Search_and_Indexing} for
more information.
}
\seealso{
\code{\link{solr_highlight}}, \code{\link{solr_facet}}
}

