% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{optimize}
\alias{optimize}
\title{Optimize}
\usage{
optimize(name, max_segments = 1, wait_searcher = TRUE,
  soft_commit = FALSE, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{name}{(character) A collection or core name. Required.}

\item{max_segments}{optimizes down to at most this number of segments. Default: 1}

\item{wait_searcher}{block until a new searcher is opened and registered as the
main query searcher, making the changes visible. Default: \code{TRUE}}

\item{soft_commit}{perform a soft commit - this will refresh the 'view' of the
index in a more performant manner, but without "on-disk" guarantees.
Default: \code{FALSE}}

\item{wt}{(character) One of json (default) or xml. If json, uses
\code{\link[jsonlite]{fromJSON}} to parse. If xml, uses \code{\link[XML]{xmlParse}} to
parse}

\item{raw}{(logical) If \code{TRUE}, returns raw data in format specified by
\code{wt} param}

\item{...}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Optimize
}
\examples{
\dontrun{
solr_connect()

optimize("gettingstarted")
optimize("gettingstarted", max_segments = 2)
optimize("gettingstarted", wait_searcher = FALSE)

# get xml back
optimize("gettingstarted", wt = "xml")
## raw xml
optimize("gettingstarted", wt = "xml", raw = TRUE)
}
}

