% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSSURGO.R
\name{createSSURGO}
\alias{createSSURGO}
\title{Create a SQLite database or GeoPackage from one or more SSURGO Exports}
\usage{
createSSURGO(
  filename,
  exdir,
  pattern = NULL,
  overwrite = FALSE,
  header = FALSE,
  ...
)
}
\arguments{
\item{filename}{Output file name (e.g. \code{'db.sqlite'} or \code{'db.gpkg'})}

\item{exdir}{Path containing containing SSURGO spatial (.shp) and tabular (.txt) files.}

\item{pattern}{Character. Optional regular expression to use to filter subdirectories of \code{exdir}. Default: \code{NULL} will search all subdirectories for SSURGO export files.#' @param include_spatial Logical. Include spatial data layers in database? Default: \code{TRUE}.}

\item{overwrite}{Logical. Overwrite existing layers? Default \code{FALSE} will append to existing tables/layers.}

\item{header}{Logical. Passed to \code{read.delim()} for reading pipe-delimited (\code{|}) text files containing tabular data.}

\item{...}{Additional arguments passed to \code{write_sf()} for writing spatial layers.}
}
\value{
Character. Vector of layer/table names in \code{filename}.
}
\description{
Create a SQLite database or GeoPackage from one or more SSURGO Exports
}
\examples{
\dontrun{
 downloadSSURGO("areasymbol IN ('CA067', 'CA077', 'CA632')", destdir = "SSURGO_test")
 createSSURGO("test.gpkg", "SSURGO_test")
}
}
