% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softImpute.R
\name{softImpute.x.Incomplete}
\alias{softImpute.x.Incomplete}
\title{rdname softImpute-internal}
\usage{
softImpute.x.Incomplete(
  x,
  J,
  lambda,
  type,
  thresh,
  maxit,
  trace.it,
  warm.start,
  final.svd
)
}
\arguments{
\item{x}{An m by n matrix with NAs. For large matrices can be of class
\code{"Incomplete"}, in which case the missing values are represented as
pseudo zeros leading to dramatic storage reduction. \code{x} can have been
centered and scaled via \code{biScale}, and this information is carried
along with the solution.}

\item{J}{Trevor to document this param}

\item{lambda}{nuclear-norm regularization parameter. If \code{lambda=0}, the
algorithm reverts to "hardImpute", for which convergence is typically
slower, and to local minimum. Ideally \code{lambda} should be chosen so that
the solution reached has rank slightly less than \code{rank.max}. See also
\code{lambda0()} for computing the smallest \code{lambda} with a zero
solution.}

\item{type}{two algorithms are implements, \code{type="svd"} or the default
\code{type="als"}. The "svd" algorithm repeatedly computes the svd of the
completed matrix, and soft thresholds its singular values. Each new
soft-thresholded svd is used to re-impute the missing entries. For large
matrices of class \code{"Incomplete"}, the svd is achieved by an efficient
form of alternating orthogonal ridge regression. The "als" algorithm uses
this same alternating ridge regression, but updates the imputation at each
step, leading to quite substantial speedups in some cases. The "als"
approach does not currently have the same theoretical convergence guarantees
as the "svd" approach.}

\item{thresh}{convergence threshold, measured as the relative change in the
Frobenius norm between two successive estimates.}

\item{maxit}{maximum number of iterations.}

\item{trace.it}{with \code{trace.it=TRUE}, convergence progress is reported.}

\item{warm.start}{an svd object can be supplied as a warm start. This is
particularly useful when constructing a path of solutions with decreasing
values of \code{lambda} and increasing \code{rank.max}. The previous
solution can be provided directly as a warm start for the next.}

\item{final.svd}{only applicable to \code{type="als"}. The alternating
ridge-regressions do not lead to exact zeros. With the default
\code{final.svd=TRUE}, at the final iteration, a one step unregularized
iteration is performed, followed by soft-thresholding of the singular
values, leading to hard zeros.}
}
\description{
rdname softImpute-internal
}
