% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerRelation.R
\name{newPowerRelation}
\alias{newPowerRelation}
\title{New Power Relation}
\usage{
newPowerRelation(
  ...,
  rankingCoalitions = list(),
  rankingComparators = c(),
  equivalenceClasses = list()
)
}
\arguments{
\item{...}{Coalition vector, comparison character (\code{">"} or \code{"~"}), coalition vector, comparison character, coalition vector, ...}

\item{rankingCoalitions}{List of ordered coalition vectors. If empty, it is ignored. Corresponds to
\verb{$rankingCoalitions} list from a \code{PowerRelation} object.}

\item{rankingComparators}{Vector of \code{">"} or \code{"~"} characters. If \code{rankingCoalitions} list is empty, it is ignored. If
vector is empty, it uses the \code{">"} relation by default.}

\item{equivalenceClasses}{Nested list of coalition vectors that are indifferent to another. If empty, it is ignored.}
}
\value{
\code{PowerRelation} object containing vector of elements or players \verb{$elements}, an ordered list of
coalitions \verb{$rankingCoalitions} and an ordered vector of comparators \verb{$rankingComparators}
as well as an ordered list of equivalence classes \verb{$equivalenceClasses} for convenience
}
\description{
Create a \code{PowerRelation} object based on coalition parameters separated by \code{">"} or \code{"~"}.
}
\details{
\loadmathjax
A power relation describes the ordinal information between coalitions.
\code{\link[=createPowerset]{createPowerset()}} offers a convenient way of creating a powerset over a set of elements that can be used to call
the \code{newPowerRelation()} function. Each coalition in that case is put
on a separate line (see example). In RStudio this allows us to easily rearrange the coalitions
using the Alt+Up or Alt+Down shortcut (Option+Up or Option+Down on MacOS).

A coalition is a \link[base:c]{vector} or a \code{\link[sets:set]{sets::set()}}. Every vector is turned into a \code{\link[sets:set]{sets::set()}}.
}
\section{Mathematical background}{


Let \mjeqn{N = \lbrace 1, ..., n \rbrace}{N = \{1, ..., n\}} be a finite set of
\emph{elements} (sometimes also called players). \mjeqn{2^N}{2^N}
describes the powerset of \mjeqn{N}{N}, or the set of all subsets, also \emph{coalitions}.

Let \mjeqn{\mathcal{P} \subseteq 2^N}{P \\subseteq 2^N} be a collection of coalitions. A
\emph{power relation} on \mjeqn{\mathcal{P}}{P} is a total preorder
\mjeqn{\succeq \subseteq \mathcal{P} \times \mathcal{P}}{>= \\subseteq P x P}.

With that, \mjeqn{\mathcal{T}(\mathcal{P})}{T(P)} denotes the family of all power relations on every
collection \mjeqn{\mathcal{P} \subseteq 2^N}{P \\subseteq 2^N}. Given a \emph{power relation}
\mjeqn{\succeq \in \mathcal{T}(\mathcal{P})}{>= in T(P)}, \mjeqn{\sim}{~} denotes its symmetric
part whereas \mjeqn{\succ}{>} its asymmetric part. For example, let \mjeqn{S, T \in \mathcal{P}}{S, T in P}. Then:

\mjdeqn{S \sim T \textrm{ if } S \succeq T \textrm{ and } T \succeq S}{S ~ T if S >= T and T >= S}

\mjdeqn{S \succ T \textrm{ if } S \succeq T \textrm{ and not } T \succeq S}{S > T if S >= T and not T >= S}
}

\examples{
if(interactive())
  createPowerset(1:3, copyToClipboard = TRUE)

# pasted clipboard and rearranged lines using
# Alt + Up, and
# Alt + Down shortcut in RStudio
pr <- newPowerRelation(
  c(1,2),
  ">", c(1,2,3),
  ">", c(1,3),
  "~", c(2),
  ">", c(1),
  "~", c(2,3),
  "~", c(3),
)

# Elements: 1 2 3
# 12 > 123 > (13 ~ 2) > (1 ~ 23 ~ 3)
print(pr)

# {1, 2, 3}
pr$elements

# {1, 2}, {1, 2, 3}, {1, 3}, {2}, {1}, {2, 3}, {3}
pr$rankingCoalitions

# ">" ">" "~" ">" ">" ">"
pr$rankingComparators

# {{1, 2}}, {{1, 2, 3}}, {{1, 3}, {2}}, {{1}, {2, 3}, {3}}
pr$equivalenceClasses

# not all coalitions of a powerset have to be present
newPowerRelation(c(1,2), ">", c(1))

# cycles produce a warning (but no errors)
newPowerRelation(c(1,2), ">", c(1), ">", c(1,2))

# use createPowerset directly
# 123 > 12 > 13 > 23 > 1 > 2 > 3 > {}
newPowerRelation(rankingCoalitions = createPowerset(1:3))

# 123 > (12 ~ 13) > (23 ~ 1) > (2 ~ 3) > {}
newPowerRelation(rankingCoalitions = createPowerset(1:3), rankingComparators = c(">", "~"))

# using equivalenceClasses parameter
# (12 ~ 13 ~ 123) > (1 ~ 3 ~ {}) > (2 ~ 23)
pr <- newPowerRelation(equivalenceClasses = list(
  list(c(1,2), c(1,3), c(1,2,3)),
  list(1, 3, c()),
  list(2, c(2,3))
))
# and manipulating the order of the equivalence classes
# (1 ~ 3 ~ {}) > (2 ~ 23) > (12 ~ 13 ~ 123)
newPowerRelation(equivalenceClasses = pr$equivalenceClasses[c(2,3,1)])


# It's discouraged to directly change the ordering of a power relation inside a
# PowerRelation object. Instead extract rankingCoalitions, rearrange the list
# and pass it to newPowerRelation
newOrdering <- rev(pr$rankingCoalitions)

# 3 > 23 > (1 ~ 2) > (13 ~ 123 ~ 12)
newPowerRelation(rankingCoalitions = newOrdering, rankingComparators = pr$rankingComparators)

# 3 > 23 > 1 > 2 > 13 > 123 > 12
newPowerRelation(rankingCoalitions = newOrdering)

}
\references{
\insertRef{2017axiomaticAndAlgorithmicPerspectives}{socialranking}

\insertRef{2019Lexcel}{socialranking}
}
\seealso{
Other newPowerRelation functions: 
\code{\link{newPowerRelationFromString}()}
}
\concept{newPowerRelation functions}
