% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/functions_array.r
\name{map.csa.all}
\alias{map.csa.all}
\title{Array of several CSA maps}
\usage{
map.csa.all(object, variable, dim = c(1, 2), ncol = 2, FUN = map.ind,
  fixed.coord = TRUE, main.title = "", titles = levels(variable), ...)
}
\arguments{
\item{object}{a \link{soc.ca} result object}

\item{variable}{a factor with the same order and length as those used for the active modalities in object}

\item{dim}{indicates what dimensions to map and in which order to plot them}

\item{ncol}{the number of columns the maps are arranged into}

\item{FUN}{the mapping function used for the plots; \link{map.active}, \link{map.ctr}, \link{map.ind}, \link{map.select} or \link{map.sup}}

\item{fixed.coord}{if TRUE the limits of all plots are set to the same as the largest plot}

\item{main.title}{the main title for all the maps}

\item{titles}{a vector of the same length as the number of levels in \code{variable}. These are the titles given to each subplot}

\item{...}{sends any further arguments to the mapping functions}
}
\description{
Creates an array of Class Specific Mulitple Correspondence analysises
}
\examples{
\dontrun{
example(soc.csa)
map.csa.all(result, active[, 1])
map.csa.all(result, active[, 1], FUN = map.ctr, ctr.dim = 1)
}
}

