% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraph_to_network.R
\name{igraph_to_network}
\alias{igraph_to_network}
\title{Create a "Network" Object from an igraph Object}
\usage{
igraph_to_network(in_graph)
}
\arguments{
\item{in_graph}{An igraph object. To create igraph objects from field data,
see \code{\link[igraph]{graph_from_edgelist}},
\code{\link[igraph]{graph_from_data_frame}},
\code{\link[igraph]{graph_from_adjacency_matrix}}, or
\code{\link[igraph]{read_graph}}.}
}
\value{
A list that contain elements:
   \item{edges}{The edgelist of the network. A two column
     \code{matrix} where each row is an edge.}
   \item{degree}{The degree sequence of the network, which is
     an \code{integer} vector of length n.}
   \item{n}{The network order.}
}
\description{
This function will take an igraph object and output a "network" which is the
compatible object for using snowboot functions.
}
\examples{
hex_ring <- igraph::make_ring(6, directed = FALSE, mutual = FALSE, circular = TRUE)
net <- igraph_to_network(hex_ring)
}
\references{
\url{http://igraph.org/}
}

