% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSMI.R
\name{LSMI}
\alias{LSMI}
\title{Snowball sampling with multiple inclusion.}
\usage{
LSMI(net, n.seeds = 10, n.neigh = 1, seeds = NULL)
}
\arguments{
\item{net}{A network object that is list containing:
\describe{
  \item{edges}{The edgelist of the network. A two column
    \code{matrix} where each row is an edge.}
  \item{degree}{The degree sequence of the network, which is
    an \code{integer} vector of length n.}
  \item{n}{The network order. The order for every network is 2000.}
}
  The object can be created by \code{\link{local.network.MR.new5}} or
  it can be imported.}

\item{n.seeds}{A number of seeds in the snowball sample.
It must be a positive integer.}

\item{n.neigh}{A number of waves to be sampled around each seed in LSMI.
For example, n.neigh = 0 corresponds to seeds only, and n.neigh = 1
corresponds to sampling seeds and their first neighbors).
Note that the algorithm allows for multiple inclusions.}

\item{seeds}{A matrix of dimension \code{num.sam} x \code{n.seeds} containing the
  numeric ids of the seeds to initiate sampling. Each row of the matrix
  corresponds to one LSMI sample. Note that this is an optional parameter.
  WARNING: As of now, this feature is only supported when
  parameter \code{n.neigh} is greater than zero.
@references Thompson, M. E., Ramirez Ramirez, L. L., Lyubchich, V. and
  Gel, Y. R. (2015), Using the bootstrap for statistical inference
  on random graphs. Can J Statistics. doi: 10.1002/cjs.11271}
}
\value{
A list containing the following elements:
   \item{seeds}{A \code{numeric} a vector containing the numeric ids of
         sampled seeds.}
   \item{sampleN}{A \code{numeric} vector containing ids of the nodes from
         the snowball sampling and the intial seeds' ids. This vector may have
         duplicates, since the algorithm allows for multiple inclusions.}
   \item{unodes}{A list of length \code{n.seeds} where each element is a
         \code{numeric} vector containing the seed's id and
         the unique ids of all nodes that were snowball sampled from
         that seed using \code{\link{sample_about_one_seed}}
         (one vector per seed).}
   \item{nodes.waves}{A list of length \code{n.seeds} where each element is
         a list of length \code{n.neigh} (Note: these lists are the output
         object \code{$nodes.waves} from
         \code{\link{sample_about_one_seed}}) that contains vectors of
         numeric id's of the nodes reached in each respective wave from the
         respective seed.}
}
\description{
The function will conduct snowball sampling.
}
\examples{
net <- artificial_networks[[1]]
a <- LSMI(net, n.seeds = 20, n.neigh = 2)
}
\references{
Thompson, M. E., Ramirez Ramirez, L. L., Lyubchich, V. and
 Gel, Y. R. (2015), Using the bootstrap for statistical inference
 on random graphs. Can J Statistics. doi: 10.1002/cjs.11271
}

