% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-utils.R
\name{internal_utils}
\alias{internal_utils}
\alias{.call}
\alias{.expand}
\alias{.set_dim}
\alias{.polygonize}
\alias{.rast_tmpl}
\alias{.modify_list}
\title{Internal utilities for native calls and helpers}
\usage{
.call(fn_name, ...)

.expand(...)

.set_dim(x, dim)

.polygonize(x)

.rast_tmpl(x)

.modify_list(x, y)
}
\description{
Lightweight wrappers for calling into the C++ backend plus helper utilities
reused throughout the package.
}
\section{Functions}{

\itemize{
  \item \code{.call(fn_name, ...)} Executes the registered C++ symbol via
    \code{.Call} and wraps errors with friendly messages.
  \item \code{.expand(...)} A thin wrapper around \code{expand.grid()} that
    drops row attributes and prevents factor coercion.
  \item \code{.set_dim(x, dim)} Re-shapes \code{x} by delegating to the
    \code{snic_set_dim} native routine.
  \item \code{.polygonize(x)} Converts a segmentation raster into polygons.
  \item \code{.rast_tmpl(x)} Builds an empty \code{terra::rast()} template
    matching the array's footprint.
  \item \code{.modify_list(x, y)} Modifies x list using named entries from y
}
}

\keyword{internal}
