% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_seq.R
\name{group_seq}
\alias{group_seq}
\alias{print.summary.group_seq}
\alias{print.group_seq}
\title{BJSM method for interim analysis and final analysis of group sequential trial design}
\usage{
group_seq(
  data,
  interim = TRUE,
  drop_threshold_pair = NULL,
  prior_dist,
  pi_prior,
  beta_prior,
  MCMC_SAMPLE,
  n.adapt,
  thin = 1,
  BURN.IN = 100,
  n_MCMC_chain,
  ci = 0.95,
  DTR = TRUE,
  cran_check_option = FALSE,
  verbose = FALSE,
  ...
)

\method{print}{summary.group_seq}(x, ...)

\method{print}{group_seq}(x, ...)
}
\arguments{
\item{data}{dataset should include 8 columns: \code{time.1st.trt} (first treatment
starts time), \code{time.1st.resp} (first response time), \code{time.2nd.trt} (second
treatment starts time), \code{time.2nd.resp} (second response time),
\code{trt.1st} (treatment arm for first treatment), \code{resp.1st} (response for first
treatment), \code{trt.2nd} (treatment arm for second treatment), \code{resp.2nd} (response
for second
treatment) data yet to be observed should be marked as "\code{NA}"}

\item{interim}{indicates whether user is conducting an interim analysis via BJSM (\code{interim} = TRUE) or an final analysis via BJSM (\code{interim} = FALSE)}

\item{drop_threshold_pair}{a vector of 2 values (\code{drop_threshold_tau_l}, \code{drop_threshold_psi_l}). Both \code{drop_threshold_tau_l} and \code{drop_threshold_psi_l} should be between 0 and 1. only assign value to this parameter when \code{interim = TRUE}. See the details section for more explanation}

\item{prior_dist}{vector of three values ("prior distribution for \code{pi}",
"prior distribution for \code{beta0}", "prior distribution for \code{beta1}"),
user can choose from "gamma", "beta", "pareto". e.g. prior_dist = c("beta",
"beta", "pareto")}

\item{pi_prior}{vector of six values (a, b, c, d, e, f), where a and b are the parameter \code{a} and parameter \code{b} of the prior distribution for \code{pi_1A}, c and d are the parameter \code{a} and parameter \code{b} of the prior distribution for \code{pi_1B}, and e and f are the parameter \code{a} and parameter \code{b} of the prior distribution for \code{pi_1C}. Please check the \code{Details} section for more explanation}

\item{beta_prior}{vector of four values (\code{beta0_prior.a}, \code{beta0_prior.b}, \code{beta1_prior.a}, \code{beta1_prior.c}).  \code{beta0_prior.a} is the parameter a of the prior distribution for linkage parameter \code{beta0}. \code{beta0_prior.b} is the parameter b of the prior distribution  for linkage parameter \code{beta0}. \code{beta1_prior.a} is the parameter a of the prior distribution for linkage parameter \code{beta1}. \code{beta1_prior.c} is the parameter b of the prior distribution for linkage parameter \code{beta1}. Please check the \code{Details} section for more explanation}

\item{MCMC_SAMPLE}{number of iterations for MCMC}

\item{n.adapt}{the number of iterations for adaptation}

\item{thin}{thinning interval for monitors}

\item{BURN.IN}{number of burn-in iterations for MCMC}

\item{n_MCMC_chain}{number of MCMC chains, default to 1}

\item{ci}{coverage probability for credible intervals, default = 0.95. only
assign value to this parameter when \code{interim = FALSE}.}

\item{DTR, }{if TRUE, will also return the expected response rate of dynamic
treatment regimens. default = TRUE. only assign value to this parameter when
\code{interim = FALSE}.}

\item{cran_check_option}{TRUE or FALSE. If FALSE, the algorithm will fit a
model like usual. This should be the default for all model fitting.
If TRUE, the model fitting is bypassed to pass CRAN check.}

\item{verbose}{TRUE or FALSE. If FALSE, no function message and progress bar will be
printed.}

\item{...}{further arguments. Not currently used.}

\item{x}{object to summarize.}
}
\value{
if \code{interim = TRUE}, this function returns either 0 - no arm is dropped,
or A/B/C - arm A/B/C is dropped \cr

if \code{interim = FALSE}, this function returns:

\describe{
\item{posterior_sample}{an \code{mcmc.list} object generated through the \code{coda.samples()} function,
which includes posterior samples of the link parameters and response rates generated through the MCMC
process}
\item{pi_hat_bjsm}{estimate of response rate/treatment effect}

\item{se_hat_bjsm}{standard error of the response rate}

\item{ci_pi_A, ci_pi_B, ci_pi_C}{x\% credible intervals for treatment A, B, C}

\item{diff_AB, diff_BC. diff_AC}{estimate of differences between treatments A
and B, B and C, A and C}

\item{ci_diff_AB, ci_diff_BC, ci_diff_AC}{x\% credible intervals for the differences
between treatments A and B, B and C, A and C}

\item{se_AB, se_BC, se_AC}{standard error for the differences between treatments
A and B, B and C, A and C}

\item{beta0_hat, beta1_hat}{linkage parameter \code{beta0} and \code{beta1} estimates}

\item{se_beta0_hat, se_beta1_hat}{standard error of the estimated value of linkage
parameter \code{beta0} and \code{beta1}}

\item{ci_beta0_hat, ci_beta1_hat}{linkage parameter \code{beta0} and \code{beta1}
credible interval}

\item{pi_DTR_est}{expected response rate of dynamic treatment regimens (DTRs)}

\item{pi_DTR_se}{standard error for the estimated DTR response rate}

\item{ci_pi_AB, ci_pi_AC, ci_pi_BA, ci_pi_BC, ci_pi_CA, ci_pi_CB}{x\% credible intervals for the estimated DTR response rate}

}
}
\description{
After obtain real trial data, this function can be used to decide which arm to
drop in an interim analysis or provide a full final analysis.
}
\details{
For \code{gamma} distribution, \code{prior.a} is the shape parameter \code{r},
\code{prior.b} is the rate parameter \code{lambda}. For \code{beta} distribution,
\code{prior.a} is the shape parameter \code{a}, \code{prior.b} is the shape parameter
\code{b}.
For \code{pareto} distribution, \code{prior.a} is the scale parameter \code{alpha},
\code{prior.b} is the shape parameter \code{c} (see page 29 of the jags user manual
version 3.4.0). link: \url{http://www.stats.ox.ac.uk/~nicholls/MScMCMC14/jags_user_manual.pdf}

The individual response rate is regarded as a permanent feature of the treatment.
The second stage outcome is modeled conditionally on the first stage results
linking the first and
second stage response probabilities through linkage parameters.

(paper provided in the reference section, section 2.2.2 Bayesian decision rules. drop_threshold_tau_l and drop_threshold_psi_l correspond to \eqn{tau_l} and \eqn{psi_l} respectively)

Please refer to the paper listed under \code{reference} section for detailed definition of parameters.
Note that this package does not include the JAGS library, users need to install JAGS separately. Please check this page for more details: \url{https://sourceforge.net/projects/mcmc-jags/}
}
\examples{
mydata <- groupseqDATA_look1

result1 <- group_seq(
  data = mydata, interim = TRUE, drop_threshold_pair = c(0.5, 0.4),
  prior_dist = c("beta", "beta", "pareto"), pi_prior = c(0.4, 1.6, 0.4, 1.6, 0.4, 1.6),
  beta_prior = c(1.6, 0.4, 3, 1), MCMC_SAMPLE = 6000, n.adapt = 1000, n_MCMC_chain = 1
)

summary(result1)


mydata <- groupseqDATA_full
result2 <- group_seq(
  data = mydata, interim = FALSE, prior_dist = c(
    "beta",
    "beta", "pareto"
  ), pi_prior = c(0.4, 1.6, 0.4, 1.6, 0.4, 1.6),
  beta_prior = c(1.6, 0.4, 3, 1), MCMC_SAMPLE = 6000, n.adapt = 1000,
  n_MCMC_chain = 1, ci = 0.95, DTR = TRUE
)

summary(result2)

}
\references{
Chao, Y.C., Braun, T.M., Tamura, R.N. and Kidwell, K.M., 2020. A Bayesian group
sequential small n sequential multiple‐assignment randomized trial. Journal of
the Royal Statistical Society: Series C (Applied Statistics), 69(3), pp.663-680.
}
