\name{find_best_selection_SA}
\alias{find_best_selection_SA}
\title{find_best_selection_SA}
\usage{
find_best_selection_SA(area_census, insms)
}
\arguments{
  \item{area_census}{A census dataset consisting of various
  areas rows.}

  \item{insms}{A microsimulation object which holds the
  data and details of the simulation such as iterations,
  lexicon.}
}
\value{
msm_results An object with the results of the simulation,
of this area.
}
\description{
Run a simulation in parallel mode with Simulated Annealing
}
\examples{
library(sms)
data(survey)
data(census)
in.lexicon=createLexicon()
in.lexicon=addDataAssociation(in.lexicon, c("he","he"))
in.lexicon=addDataAssociation(in.lexicon, c("females","female"))

this_area=as.data.frame(census[1,]) #Select the first area from the census table
insms= new("microsimulation",census=census, panel=survey, lexicon=in.lexicon, iterations=5)
myselection= find_best_selection_SA( this_area, insms)
print(myselection)
}
\author{
Dimitris Kavroudakis \email{dimitris123@gmail.com}
}

