% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_add_line.R
\name{sm_add_line}
\alias{sm_add_line}
\title{Adding a line annotation in the combined plot}
\usage{
sm_add_line(x, y, xend, yend, color = "black", linewidth = 0.5, ...)
}
\arguments{
\item{x}{Starting location of the line along the x-axis of the combined figure. The middle origin is at 0.5. Values from 0 to 1.}

\item{y}{Starting location of the line along the y-axis of the combined figure. The middle origin is at 0.5. Values from 0 to 1.}

\item{xend}{Final location of the line along the x-axis of the combined figure. The middle origin is at 0.5. Values from 0 to 1.}

\item{yend}{Final location of the line along the y-axis of the combined figure. The middle origin is at 0.5. Values from 0 to 1.}

\item{color}{Color of the line. Default is set to black.}

\item{linewidth}{Thickness of the line. Default is set to 0.5.}

\item{...}{Other parameters of the line that will be transferred to the function annotate()
from ggplot2.}
}
\value{
Prints a line to the combined plot.
}
\description{
Adding a line annotation in the combined plot
}
\examples{
library(ggplot2)
library(smplot2)

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
geom_point(shape = 21, fill = '#0f993d', color = 'white',
          size = 3) -> p1

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
 geom_point(shape = 21, fill = '#0f993d', color = 'white', size = 3) +
 sm_hvgrid() -> p2

combined_fig <- sm_put_together(list(p1,p2), ncol=2,nrow=1)
combined_fig + sm_add_line(x = 0.4, y = 0.4, xend = 0.6, yend = 0.6)

}
