% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leverage_and_influence.R
\name{lev_inf}
\alias{lev_inf}
\title{Leverage and influence in simple linear regression movie}
\usage{
lev_inf(
  association = c("positive", "negative", "none"),
  n = 25,
  panel_plot = TRUE,
  hscale = NA,
  vscale = hscale
)
}
\arguments{
\item{association}{A character scalar.  Determines the type of association
between (not-outlying) observations: "positive" for positive linear
association; "negative" negative linear association; "none" for no
association.}

\item{n}{An integer scalar.  The size of the sample of (non-outlying)
observations.}

\item{panel_plot}{A logical parameter that determines whether the plot
is placed inside the panel (\code{TRUE}) or in the standard graphics
window (\code{FALSE}).  If the plot is to be placed inside the panel
then the tkrplot library is required.}

\item{hscale, vscale}{Numeric scalars.  Scaling parameters for the size
of the plot when \code{panel_plot = TRUE}. The default values are 1.4 on
Unix platforms and 2 on Windows platforms.}
}
\value{
Nothing is returned, only the animation is produced.
}
\description{
A movie to examine the influence of a single outlying observation on a
least squares regression line.
}
\details{
\code{n} pairs of observations are simulated with the property
  that the mean of response variable \eqn{y} is a linear function of the
  values of the explanatory variable \eqn{x}.  These pairs of observations
  are plotted using filled black circles.  An extra observation is plotted
  using a filled red circle.  Initially this observation is placed in the
  middle of the plot.

  Superimposed on the plot are two least squares regression lines:
  one based on all the data (`with observation') and one in which the
  `red' observation has been removed (`without observation'.
  Initially these lines coincide.

  The location of the `red' observation can be changed using the
  +/- buttons so that the effect of the position of this observation
  on the `with observation' line can be seen.

  We see that if the red observation is outlying, that is, it is far
  from the least squares line fitted to the other observations, then
  its \strong{influence} on the least squares regression line depends on
  its x-coordinate.  If its x-coordinate is much larger or smaller than
  the x-coordinate of the other observations (\strong{high leverage}) then
  the influence is higher than if it has a similar x-coordinate to the
  other observations (\strong{low leverage}).  An observation with high
  leverage does not necessarily have high influence: if its y-coordinate
  falls very close to the regression line fitted to the other observations
  then its influence will be low.
}
\examples{
# Positive association
lev_inf()

# No association
lev_inf(association = "none")
}
\seealso{
\code{\link{movies}}: a user-friendly menu panel.

\code{\link{smovie}}: general information about smovie.
}
