% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{orders}
\alias{orders}
\alias{lags}
\alias{modelName}
\alias{modelType}
\title{Functions that extract values from the fitted model}
\usage{
orders(object, ...)

lags(object, ...)

modelName(object, ...)

modelType(object, ...)
}
\arguments{
\item{object}{Model estimated using one of the functions of smooth package.}

\item{...}{Currently nothing is accepted via ellipsis.}
}
\value{
Either vector, scalar or list with values is returned.
\code{orders()} in case of ssarima returns list of values:
\itemize{
\item \code{ar} - AR orders.
\item \code{i} - I orders.
\item \code{ma} - MA orders.
}
\code{lags()} returns the vector of lags of the model.
All the other functions return strings of character.
}
\description{
These functions allow extracting orders and lags for \code{ssarima()}, \code{gum()} and \code{sma()},
type of model from \code{es()} and \code{ces()} and name of model.
}
\details{
\code{orders()} and \code{lags()} are useful only for SSARIMA, GUM and SMA. They return \code{NA} for other functions.
This can also be applied to \code{arima()}, \code{Arima()} and \code{auto.arima()} functions from stats and forecast packages.
\code{modelType()} is useful only for ETS and CES. They return \code{NA} for other functions.
This can also be applied to \code{ets()} function from forecast package. \code{errorType}
extracts the type of error from the model (either additive or multiplicative). Finally, \code{modelName}
returns the name of the fitted model. For example, "ARIMA(0,1,1)". This is purely descriptive and
can also be applied to non-smooth classes, so that, for example, you can easily extract the name
of the fitted AR model from \code{ar()} function from \code{stats} package.
}
\examples{

x <- rnorm(100,0,1)

# Just as example. orders and lags do not return anything for ces() and es(). But modelType() does.
ourModel <- ces(x, h=10)
orders(ourModel)
lags(ourModel)
modelType(ourModel)
modelName(ourModel)

# And as another example it does the opposite for gum() and ssarima()
ourModel <- gum(x, h=10, orders=c(1,1), lags=c(1,4))
orders(ourModel)
lags(ourModel)
modelType(ourModel)
modelName(ourModel)

# Finally these values can be used for simulate functions or original functions.
ourModel <- auto.ssarima(x)
ssarima(x, orders=orders(ourModel), lags=lags(ourModel), constant=ourModel$constant)
sim.ssarima(orders=orders(ourModel), lags=lags(ourModel), constant=ourModel$constant)

ourModel <- es(x)
es(x, model=modelType(ourModel))
sim.es(model=modelType(ourModel))

}
\seealso{
\link[smooth]{ssarima}, \link[smooth]{msarima}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
