\name{sim.ssarima}
\alias{sim.ssarima}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
    Simulate SSARIMA
}
\description{
    Function generates data using SSARIMA with Single Source of Error as a data generating process.
}
\usage{
sim.ssarima(ar.orders=0, i.orders=1, ma.orders=1, lags=1,
            frequency=1, AR=NULL, MA=NULL, constant=FALSE,
            initial=NULL, bounds=c("admissible","none"),
            obs=10, nsim=1, silent=FALSE,
            randomizer=c("rnorm","runif","rbeta","rt"),
            iprob=1, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{ar.orders}{
    Vector of autoregressive orders, corresponding to seasonal lags. For example \code{ar.orders=c(1,1)} with \code{lags=c(1,12)} will lead to model with AR(1), SAR(1).
  }
  \item{i.orders}{
    Vector of differences, corresponding to seasonal lags. For example \code{i.orders=c(0,1)} with \code{lags=c(1,12)} will lead to model with I(0), SI(1).
  }
  \item{ma.orders}{
    Vector of moving average orders, corresponding to seasonal lags. For example \code{i.orders=c(1,2)} with \code{lags=c(1,12)} will lead to model with MA(1), SMA(2).
  }
  \item{lags}{
    Defines lags for the corresponding orders (see examples above). The length of \code{lags} must correspond to the length of either \code{ar.orders} or \code{i.orders} or \code{ma.orders}. There is no restrictions on the length of \code{lags} vector. It is recommended to order \code{lags} ascending.
  }
  \item{frequency}{
    Frequency of generated data. In cases of seasonal models must be greater than 1.
  }
  \item{AR}{
    Vector or matrix of AR parameters. The order of parameters should be lag-wise. This means that first all the AR parameters of the firs lag should be passed, then for the second etc. AR of another ssarima can be passed here.
  }
  \item{MA}{
    Vector or matrix of MA parameters. The order of parameters should be lag-wise. This means that first all the MA parameters of the firs lag should be passed, then for the second etc. MA of another ssarima can be passed here.
  }
  \item{constant}{
    If \code{TRUE}, constant term is included in the model. Can also be a number (constant value).
  }
  \item{initial}{
    Vector of initial values for state matrix. If \code{NULL}, then generated using advanced, sophisticated technique - uniform distribution.
  }
  \item{bounds}{
    Type of bounds to use for AR and MA if values are generated. \code{"admissible"} - bounds guaranteeing stability and stationarity of SSARIMA. \code{"none"} - we generate something, but do not guarantee stationarity and stability. Using first letter of the type of bounds also works.
  }
  \item{obs}{
    Number of observations in each generated time series.
  }
  \item{nsim}{
    Number of series to generate (numeber of simulations to do).
  }
  \item{silent}{
    If TRUE then no output is printed.
  }
  \item{randomizer}{
    Type of random number generator function used for error term. Defaults are: \code{rnorm}, \code{rt}, \code{runif}, \code{rbeta}. But any function from \link[stats]{Distributions} will do the trick if the appropriate parameters are passed. For example \code{rpois} with \code{lambda=2} can be used as well.
  }
  \item{iprob}{
    Probability of occurrence, used for intermittent data generation.
  }
  \item{...}{
    Additional parameters passed to the chosen randomizer. All the parameters should be passed in the order they are used in chosen randomizer. For example, passing just \code{sd=0.5} to \code{rnorm} function will lead to the call \code{rnorm(obs, mean=0.5, sd=1)}.
  }
}
\value{
    List of the following values is returned:
        \item{model}{Name of SSARIMA model.}
        \item{AR}{Value of AR parameters. If \code{nsim>1}, then this is a matrix.}
        \item{MA}{Value of MA parameters. If \code{nsim>1}, then this is a matrix.}
        \item{constant}{Value of constant term. If \code{nsim>1}, then this is a vector.}
        \item{initial}{Initial values of SSARIM. If \code{nsim>1}, then this is a matrix.}
        \item{data}{Time series vector (or matrix if \code{nsim>1}) of the generated series.}
        \item{states}{Matrix (or array if \code{nsim>1}) of states. States are in columns, time is in rows.}
        \item{residuals}{Error terms used in the simulation. Either vector or matrix, depending on \code{nsim}.}
        \item{occurrences}{Values of occurrence variable. Once again, can be either a vector or a matrix...}
        \item{likelihood}{Log-likelihood of the constructed model.}
}
\references{
    Snyder, R.D. (1985) Recursive Estimation of Dynamic Linear Models. Journal of the Royal Statistical Society. Series B. Vol. 47, No. 2, pp. 272-276.
}
\author{
    Ivan Svetunkov, \email{ivan@svetunkov.ru}
}

\seealso{
    \code{\link[smooth]{sim.es}, \link[smooth]{es}, \link[stats]{Distributions}}
}
\examples{
# Create 120 observations from ARIMA(1,1,1) with drift. Generate 100 time series of this kind.
x <- sim.ssarima(ar.orders=1,i.orders=1,ma.orders=1,obs=120,nsim=100,constant=TRUE)

# Generate similar thing for seasonal series of SARIMA(1,1,1)(0,0,2)_4
x <- sim.ssarima(ar.orders=c(1,0),i.orders=c(1,0),ma.orders=c(1,2),lags=c(1,4),
                 frequency=4,obs=80,nsim=100,constant=FALSE)

# Generate 10 series of high frequency data from SARIMA(1,0,2)_1(0,1,1)_7(1,0,1)_30
x <- sim.ssarima(ar.orders=c(1,0,1),i.orders=c(0,1,0),ma.orders=c(2,1,1),lags=c(1,7,30),
                 obs=360,nsim=10)

}

\keyword{ SARIMA }
\keyword{ ARIMA }
\keyword{ forecasting }
\keyword{ simulation }
