% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{predict.smog}
\alias{predict.smog}
\title{predict method for objects of the class smog}
\usage{
\method{predict}{smog}(object, newdata = NULL, family = "gaussian", ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from smog.}

\item{newdata}{a data frame containing the predictor variables, which are
used to predict. If omitted, the fitted linear predictors 
are used.}

\item{family}{a description of distribution family for which the response 
variable is to be predicted.}

\item{...}{additional arguments affecting the predictions produced.}
}
\value{
If \code{family} = ``gaussian'', a vector of prediction for the response is returned.
        For \code{family} = ``coxph'', a vector of predicted survival 
        probability is returned. When \code{family} = ``binomial'', it outputs a data
        frame containing the predicted group labels and the corresponding 
        probabilies.
}
\description{
\code{predict.smog} can produce the prediction for user-given new data, based on the
provided fitted model (\code{object}) in the S3method of \code{smog}. If the \code{newdata} omitted,
it would output the prediction for the fitted model itself. The yielded result should
match with the family in the provided model. See \code{\link{smog}}.
}
\details{
If \code{newdata = NULL}, the fitted.value based on the \code{object}
         is used for the prediction.
}
\references{
\insertRef{ma2019structural}{smog}
}
\seealso{
\code{\link{smog.default}}, \code{\link{smog.formula}}, \code{\link{cv.smog}}, \code{\link{plot.smog}}.
}
\author{
Chong Ma, \email{chongma8903@gmail.com}.
}
