% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{smdocker_log}
\alias{smdocker_log}
\title{smdocker logging system}
\usage{
smdocker_log(
  level = 3L,
  file = "",
  timestamp_fmt = "\%Y-\%m-\%d \%H:\%M:\%OS3"
)
}
\arguments{
\item{level}{(integer): the level logging threshold.
\itemize{
\item{4L :} {DEBUG}
\item{3L :} {INFO}
\item{2L :} {WARNING}
\item{1L :} {ERROR}
}}

\item{file}{(character): path for logs to populate, default output logs to console.}

\item{timestamp_fmt}{(character): timestamp format, see \code{\link[=format.POSIXct]{format.POSIXct()}}.}
}
\value{
\code{NULL} invisible
}
\description{
Ability to configure smdocker logging system, through the use of smdocker
helper function \code{smdocker_log} or \code{R:base} \code{options} function. \code{options} configurable
parameters:
\itemize{
\item{\code{smdocker.log_level}} {(integer): The minimum log level that should be tracked}
\item{\code{smdocker.log_file}} {
(character): path for logs to populate, default output logs to console.
}
\item{\code{smdocker.log_timestamp_fmt}} {(character): see \code{\link[=format.POSIXct]{format.POSIXct()}}}
}
}
\examples{
\dontrun{
# log to a file
temp_file <- tempfile()
smdocker_log(file = temp_file)

# change log threshold to INFO
smdocker_log(level = 3L)

# reset to default config
smdocker_log()

# options() equivalents:

# log to a file
temp_file <- tempfile()
options(smdocker.log_file = temp_file)

# change log threshold to INFO
options(smdocker.log_level = 3L)
}
}
