% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm2.R
\name{sm2_sign}
\alias{sm2_sign}
\alias{sm2_verify}
\alias{sm2_sign_to_file}
\alias{sm2_verify_from_file}
\title{SM2 Sign/Verify}
\usage{
sm2_sign(id, data, private_key)

sm2_verify(id, data, sign, public_key)

sm2_sign_to_file(id, data, sign_file, private_key)

sm2_verify_from_file(id, data, sign_file, public_key)
}
\arguments{
\item{id}{the signer's id, must be a raw vector}

\item{data}{orignal data, must be a raw vector}

\item{private_key}{a private key represented as a hexadecimal string}

\item{sign}{sign data of the original data or file}

\item{public_key}{a public key represented as a hexadecimal string}

\item{sign_file}{file path of the sign data to load}
}
\value{
\describe{
  \item{\link{sm2_sign}}{returns a raw vector contains the signature}
  \item{\link{sm2_verify}}{returns 1 if verified, 0 if not verified}
  \item{\link{sm2_sign_to_file}}{returns nothing, and a signature file will be saved in the specified path}
  \item{\link{sm2_verify_from_file}}{returns 1 if verified, 0 if not verified}
}
}
\description{
SM2 is an asymmetric encryption algorithm, so it can be used to sign and verify
signatures of data. The purpose of doing this is to ensure the integrity of
the data and guarantee its authenticity. Typically, the data owner uses the
SM3 message digest algorithm to calculate the hash value and signs it with the
private key, generating signed data. Then the owner distributes the original
data and the signed data of the original data to the receiver. The receiver
uses the public key and the received signed data to perform the verification
operation. If the verification is successful, it is considered that the
received original data has not been tampered with.
}
\examples{
## sign and verify
id <- charToRaw('yumeng@company.com')
data <- charToRaw('abc')
keypair <- sm2_gen_keypair()
private_key <- keypair$private_key
public_key <- keypair$public_key
sign_data <- sm2_sign(id, data, private_key)
verify_result <- sm2_verify(id, data, sign_data, public_key)
\dontrun{
  sm2_sign_to_file(id, data, 'sign_data.sig', private_key)
  sm2_verify_from_file(id, data, 'sign_data.sig', public_key)
}
}
