% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.eda}
\alias{smbinning.eda}
\title{Exploratory Data Analysis (EDA)}
\usage{
smbinning.eda(df, rounding = 3, pbar = 1)
}
\arguments{
\item{df}{A data frame.}

\item{rounding}{Optional parameter to define the decimal points shown in the output table. Default is 3.}

\item{pbar}{Optional parameter that turns on or off a progress bar. Default value is 1.}
}
\value{
The command \code{smbinning.eda} generates two data frames that list each characteristic 
with basic statistics such as extreme values and quartiles;
and also percentages of missing values and outliers, among others.
}
\description{
It shows basic statistics for each characteristic in a data frame.
The report includes:
\itemize{
  \item Field: Field name.
  \item Type: Factor, numeric, integer, other.
  \item Recs: Number of records.
  \item Miss: Number of missing records.
  \item Min: Minimum value.
  \item Q25: First quartile. It splits off the lowest 25\% of data from the highest 75\%.
  \item Q50: Median or second quartile. It cuts data set in half.
  \item Avg: Average value.
  \item Q75: Third quartile. It splits off the lowest 75\% of data from the highest 25\%.
  \item Max: Maximum value.
  \item StDv: Standard deviation of a sample.
  \item Neg: Number of negative values.
  \item Pos: Number of positive values.
  \item OutLo: Number of outliers. Records below \code{Q25-1.5*IQR}, where \code{IQR=Q75-Q25}. 
  \item OutHi: Number of outliers. Records above \code{Q75+1.5*IQR}, where \code{IQR=Q75-Q25}.
  }
}
\examples{
# Load library and its dataset
library(smbinning) # Load package and its data

# Example: Exploratory data analysis of dataset
smbinning.eda(smbsimdf1,rounding=3)$eda # Table with basic statistics
smbinning.eda(smbsimdf1,rounding=3)$edapct # Table with basic percentages
}
