% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning}
\alias{smbinning}
\title{Optimal Binning for Scoring Modeling}
\usage{
smbinning(df, y, x, p = 0.05)
}
\arguments{
\item{df}{A data frame.}

\item{y}{Binary response variable (0,1). Integer (\code{int}) is required.
Name of \code{y} must not have a dot. Name "default" is not allowed.}

\item{x}{Continuous characteristic. At least 5 different values. Value \code{Inf} is not allowed.
Name of \code{x} must not have a dot.}

\item{p}{Percentage of records per bin. Default 5\% (0.05). 
This parameter only accepts values greater that 0.00 (0\%) and lower than 0.50 (50\%).}
}
\value{
The command \code{smbinning} generates and object containing the necessary info and utilities for binning.
The user should save the output result so it can be used 
with \code{smbinning.plot}, \code{smbinning.sql}, and \code{smbinning.gen}.
}
\description{
\strong{Optimal Binning} categorizes a numeric characteristic into bins for ulterior usage in scoring modeling.
This process, also known as \emph{supervised discretization}, 
utilizes \href{https://cran.r-project.org/package=partykit}{Recursive Partitioning} to categorize 
the numeric characteristic.\cr
The especific algorithm is Conditional Inference Trees 
which initially excludes missing values (\code{NA}) to compute the cutpoints, adding them back later in the 
process for the calculation of the \emph{Information Value}.
}
\examples{
# Package loading
library(smbinning) # Load package and its data
data(chileancredit) # Load smbinning sample dataset (Chilean Credit)

# Population, training and testing samples (Just some basic formality for Modeling) 
pop=chileancredit # Set population
train=subset(pop,Rnd<=0.7) # Training sample
test=subset(pop,Rnd>0.7) # Testing sample
rm(chileancredit)

# Package application
result=smbinning(df=train,y="FlagGB",x="LnTOB") # Run and save result
result$ivtable # Tabulation and Information Value
result$iv # Information value
result$bands # Bins or bands
result$ctree # Decision tree
}
