% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kdest.R
\name{kdest}
\alias{kdest}
\title{Difference of estimated K functions}
\usage{
kdest(
  x,
  case = 2,
  nsim = 0,
  level = 0.95,
  r = NULL,
  rmax = NULL,
  breaks = NULL,
  correction = c("border", "isotropic", "Ripley", "translate"),
  nlarge = 3000,
  domain = NULL,
  var.approx = FALSE,
  ratio = FALSE
)
}
\arguments{
\item{x}{A \code{\link[spatstat.geom]{ppp}} object
package with marks for the case and control groups.
\code{x$marks} is assumed to be a factor. Automatic
conversion is attempted if it is not.}

\item{case}{The name of the desired "case" group in
\code{levels(x$marks)}. Alternatively, the position of
the name of the "case" group in \code{levels(x$marks)}.
Since we don't know the group names, the default is 2,
the second position of \code{levels(x$marks)}.
\code{x$marks} is assumed to be a factor.  Automatic
conversion is attempted if it is not.}

\item{nsim}{The number of simulated data sets from which
to construct tolerance envelopes under the random
labeling hypothesis.  The default is 0 (i.e., no
envelopes).}

\item{level}{The level of the tolerance envelopes.}

\item{r}{
    Optional. Vector of values for the argument \eqn{r} at which \eqn{K(r)} 
    should be evaluated. Users are advised \emph{not} to specify this
    argument; there is a sensible default. If necessary, specify \code{rmax}.
  }

\item{rmax}{
    Optional. Maximum desired value of the argument \eqn{r}.
  }

\item{breaks}{
    This argument is for internal use only.
  }

\item{correction}{
    Optional. A character vector containing any selection of the
    options \code{"none"}, \code{"border"}, \code{"bord.modif"},
    \code{"isotropic"}, \code{"Ripley"}, \code{"translate"},
    \code{"translation"}, \code{"rigid"},
    \code{"none"}, \code{"periodic"}, \code{"good"} or \code{"best"}.
    It specifies the edge correction(s) to be applied.
    Alternatively \code{correction="all"} selects all options.
  }

\item{nlarge}{
    Optional. Efficiency threshold.
    If the number of points exceeds \code{nlarge}, then only the
    border correction will be computed (by default), using a fast algorithm.
  }

\item{domain}{
    Optional. Calculations will be restricted to this subset
    of the window. See Details.
  }

\item{var.approx}{Logical. If \code{TRUE}, the approximate
    variance of \eqn{\hat K(r)}{Kest(r)} under CSR
    will also be computed.
  }

\item{ratio}{
    Logical. 
    If \code{TRUE}, the numerator and denominator of
    each edge-corrected estimate will also be saved,
    for use in analysing replicated point patterns.
  }
}
\value{
Returns a \code{kdenv} object.  See documentation
  for \code{\link[spatstat.explore]{Kest}}.
}
\description{
\code{kdest} computes the difference in estimated K functions for a set of
cases and controls, with \code{KD(r) = K_case(r) - K_control(r)} denoting the
estimated difference at distance \code{r}. If \code{nsim > 0}, then pointwise
tolerance envelopes for \code{KD(r)} are constructed under the random
labeling hypothesis for each distance \code{r}. The \code{summary} function
can be used to determine the distances for which \code{KD(r)} is above or
below the tolerance envelopes. The \code{plot} function will plot
\code{KD(r)} versus r, along with the tolerance envelopes, the min/max
envelopes of \code{KD(r)} simulated under the random labeling hypothesis, and
the average KD(r) under the random labeling hypothesis.
}
\details{
This function relies internally on the \code{\link[spatstat.explore]{Kest}} and
\code{\link[spatstat.explore]{eval.fv}} functions.  The arguments are essentially the same as the
\code{\link[spatstat.explore]{Kest}} function, and the user is referred there
for more details about the various arguments.
}
\examples{
data(grave)
# estimate and plot KD(r)
kd1 = kdest(grave, case = "affected")
plot(kd1, iso ~ r, ylab = "difference", legend = FALSE, main = "")
kd2 = kdest(grave, case = 2, nsim = 9, level = 0.8)
kd2 # print object
summary(kd2) # summarize distances KD(r) outside envelopes
plot(kd2)
# manually add legend
legend("bottomright", legend = c("obs", "avg", "max/min env", "95\% env"),
       lty = c(1, 2, 1, 2), col = c("black", "red", "darkgrey", "lightgrey"),
       lwd = c(1, 1, 10, 10))
}
\references{
Waller, L.A. and Gotway, C.A. (2005). 
  Applied Spatial Statistics for Public Health Data. 
  Hoboken, NJ: Wiley.
}
\seealso{
\code{\link[spatstat.explore]{Kest}},
  \code{\link[spatstat.explore]{eval.fv}}
}
\author{
Joshua French
}
