%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-11-08 :05:09.
% Do NOT modify this file, instead modify the source (Rarray.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.norm.exp}
\alias{stat.norm.exp}
\title{Normalization of log Intensity Ratios across slides / experiments.}

\description{
Performs scale normalization across slides (experiments)}
}

\usage{
stat.norm.exp(X)
}

\arguments{
  \item{X}{X is a matrix of log intensity ratios \eqn{M=\log_2 (R/G)}
  The rows of X correspond to genes and columns correspond to different 
  hybridizations, that is different slides (experiments).} 
}

\value{
  A matrix of normalized log intensity ratios across different slides. 
  For the matrix in each of the components, rows correspond to genes
  and columns correspond to different hybridizations, that is different 
  slides.  This methods scale the matrix such that each column has the 
  same median absolute deviation.
}

\references{Y. H. Yang, S. Dudoit, P. Luu and T. P. Speed. 
 Normalization for cDNA Microarray Data. (Statistics, UC Berkeley, 
 Tech Report \# 589).  } 

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
}

\seealso{\code{\link{ma.func}}, \code{\link{norm.l.func}},
  \code{\link{norm.pin.func}}, \code{\link{norm.scale.func}}, \code{\link{plot.mva}}, \code{\link{lowess}}.}

\examples{
data(MouseArray)
## mouse.setup <- init.grid() 
## mouse.data <- init.data() ## see \emph{init.data} 
mouse.lratio <- stat.ma(mouse.data, mouse.setup)
mouse.norm.lratio <- stat.norm.exp(mouse.lratio$M)
}

\keyword{manip}
%\keyword{microarray, log ratio, normalization.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
