\name{plot.print.tip.lowess}

\alias{plot.print.tip.lowess}
  
\title{M vs. A Plot with print tip lowess lines}

\description{
For a single slide, this function produces a scatter plot of log
intensity ratios \eqn{M = log_2(R/G)} versus average log intensities
\eqn{A = log_2 \sqrt{RG}}{A = log_2(R*G)/2}, where R and G represent
the fluorescence intensities in the red and green channels
respectively. Superimposed on this plot are individual lowess
smootherlines, one for each pin group.
}

\usage{
plot.print.tip.lowess(x, layout, norm="n", image.id=1,palette = rainbow(layout$ngrid.r*layout$ngrid.c), lty.palette = rep(1,layout$ngrid.r*layout$ngrid.c),...)
}

\arguments{
  \item{x}{A list with at least 4 elements.  Each element of the list
    being a matrix with p rows for p genes and n columns for n slides. 
    The first element 'R' contains the raw red intensities,
    the second element 'G' contains the raw green intensities,
    the third element 'Rb' contains the background red intensities and
    the 4th element 'Gb' contains the background green intensities.
    This data structure can be generated by an interactive function
    \code{\link{init.data}}.}  

  \item{layout}{a list specifying the dimensions of the spot matrix
  and the grid matrix.  This can be generated by calling
  \code{\link{init.grid}}.} 

  \item{norm}{character string, one of "n", "m", "l", "p" or "s".  This
    argument  specifies the type of normalization method to be
    performed: "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization.} 
    
  \item{image.id}{integer value; the index of the slide which is considered.}
  \item{palette}{Vector of color values to color each of the print tip
    lowess lines}
  \item{lty.palette}{A vector of line types for each of the print tip
    lowess lines}
  \item{\dots}{graphical parameters may also be supplied as arguments to the
    function (see \code{\link{par}}).  }
}

\value{A plot is created on the current graphics device.  The top
plot is based on unnormalized log ratios and the bottom plot is
based on normalized log ratios.} 

\details{M vs. A plots tend to be more revealing than their log R
vs. log G counterparts in terms of identifying spot artifacts and
detecting intensity dependent patterns in the log ratios. They are
also very useful for normalization.} 

\references{S. Dudoit, Y. H. Yang, M. J. Callow, and T. P. Speed. Statistical
methods for identifying differentially expressed genes in replicated
cDNA microarray experiments (Statistics, UC Berkeley, Tech Report \#
578).}

\author{
	Ben Bolstad \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{ma.func}}, \code{\link{plot.smooth.line}},
\code{\link{stat.ma}}, \code{\link{lowess}}, \code{\link{plot}}.} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
plot.print.tip.lowess(mouse.data,mouse.setup)
}     

%\keyword{microarray}

\keyword{hplot}




