% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slick_div.R
\name{slick_div}
\alias{slick_div}
\title{Create a DOM element for slickR}
\usage{
slick_div(
  x,
  css = htmltools::css(marginLeft = "auto", marginRight = "auto"),
  type = "img",
  links = NULL
)
}
\arguments{
\item{x}{object}

\item{css}{\link[htmltools:css]{css} object,
Default: htmltools::css(marginLeft='auto',marginRight='auto')}

\item{type}{character, type of DOM, Default: 'img'}

\item{links}{character, links to use on the input object, Default: NULL}
}
\value{
list of shiny tag objects
}
\description{
Wraps an R object in slickR compatible DOM
}
\details{
Method converts xml_document, htmlwidget, character, or list of objects
to a compatible DOM
}
\examples{

# image
slick_div(nba_team_logo$uri[1])

# vector of images
slick_div(nba_team_logo$uri[c(1:5)])

# text
slick_div('abc',type = 'p')

}
\seealso{
Other html: 
\code{\link{slick_list}()}
}
\concept{html}
