% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_nodes}
\alias{ts_nodes}
\title{Extract combined annotated table of individuals and nodes}
\usage{
ts_nodes(x, sf = TRUE)
}
\arguments{
\item{x}{Tree sequence object of the class \code{slendr_ts} or a \code{phylo}
object extracted by \code{ts_phylo}}

\item{sf}{Should spatial data be returned in an sf format? If \code{FALSE},
spatial geometries will be returned simply as x and y columns, instead of
the standard POINT data type.}
}
\value{
Data frame with processed information from the tree sequence object.
If the model which generated this data was spatial, result will be returned
as a spatial object of the class \code{sf}.
}
\description{
This function combines information from the table of individuals and table of
nodes into a single data frame which can be used in downstream analyses.
}
\details{
The source of data (tables of individuals and nodes recorded in the tree
sequence generated by SLiM) are combined into a single data frame. If the
model which generated the data was spatial, coordinates of nodes (which are
pixel-based by default because SLiM spatial simulations occur on a raster),
the coordinates are automatically converted to an explicit spatial object of
the \code{sf} class unless \code{spatial = FALSE}. See
\url{https://r-spatial.github.io/sf/} for an extensive introduction to the sf
package and the ways in which spatial data can be processed, analysed, and
visualised.
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model)

# extract an annotated table with (spatio-)temporal node information
ts_nodes(ts)
}
\seealso{
\code{\link{ts_table}} for accessing raw tree sequence tables
without added metadata annotation. See also \code{\link{ts_ancestors}} to
learn how to extract information about relationship beteween nodes in the
tree sequence, and how to analysed data about distances between nodes in
the spatial context.
}
