% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_samples}
\alias{ts_samples}
\title{Extract names and times of individuals of interest in the current tree sequence
(either all sampled individuals or those that the user simplified to)}
\usage{
ts_samples(ts)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}
}
\value{
Table of individuals scheduled for sampling across space and time
}
\description{
Extract names and times of individuals of interest in the current tree sequence
(either all sampled individuals or those that the user simplified to)
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model, simplify = TRUE)

# extract the table of individuals scheduled for simulation and sampling
ts_samples(ts)
}
