% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleepwalk.R
\name{slw_snapshot}
\alias{slw_snapshot}
\title{Make a snapshot of the currently running Sleepwalk app}
\usage{
slw_snapshot(point, emb = 1, returnList = FALSE)
}
\arguments{
\item{point}{an index of the focus point (i.e. the one, over which the mouse is hovering at the moment).
To learn the index of a point double click on it in the web browser.}

\item{emb}{an index of the embedding of the focus point. To learn the index of an embedding double click 
on any of its points in the web browser.}

\item{returnList}{if \code{TRUE} returns a list of \code{ggplot} objects (one per embedding), that can be easily 
modified later. Otherwise returns a single \code{ggplot} objects with all the embeddings.}
}
\value{
a \code{ggplot} object or a list of \code{ggplot} objects.
}
\description{
This function produces a static plot that shows a given state of the 
currently active Sleepwalk app. Double click on a point in the web browser
will generate a command that can reproduce this exact state of the app.
}
\examples{
\donttest{data("iris")
sleepwalk(iris[, c(1,3)], iris[1:4], pointSize = 4)
slw_snapshot(10)}

}
