#' Gather Loser Playoff Bracket
#'
#' Given a league ID, get the loser playoff bracket for the league.
#'
#' @return Returns a data frame containing playoff information for the loser bracket.
#' @author Nick Bultman, \email{njbultman74@@gmail.com}, December 2021
#' @keywords league playoff loser
#' @importFrom httr GET content
#' @importFrom jsonlite fromJSON
#' @export
#' @examples
#' \dontrun{get_loser_playoff_bracket(688281863499907072)}
#'
#' @param league_id League ID generated by Sleeper (numeric or character)
#'
get_loser_playoff_bracket <- function(league_id) {
  # Execute query to API given league ID specified
  x <- jsonlite::fromJSON(httr::content(httr::GET(paste0("https://api.sleeper.app/v1/league/", league_id, "/losers_bracket")), as = "text"))
  # Check if returned object is NULL
  if(is.null(x)) {
    # If NULL, inform the user and return nothing
    message("League ID did not return any results. Did you enter the league ID correctly?")
  } else {
    # If not NULL, return the object (data frame)
    return(x)
  }
}
