% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{slackr}
\alias{slackr}
\title{Output R expressions to a \code{slack.com} channel/user}
\usage{
slackr(..., channel = Sys.getenv("SLACK_CHANNEL"),
  username = Sys.getenv("SLACK_USERNAME"),
  icon_emoji = Sys.getenv("SLACK_ICON_EMOJI"),
  api_token = Sys.getenv("SLACK_API_TOKEN"))
}
\arguments{
\item{...}{expressions to be sent to Slack.com}

\item{channel}{which channel to post the message to (chr)}

\item{username}{what user should the bot be named as (chr)}

\item{icon_emoji}{what emoji to use (chr) \code{""} will mean use the default}

\item{api_token}{your full slack.com API token}
}
\description{
Takes an \code{expr}, evaluates it and sends the output to a \url{slack.com}
chat destination. Useful for logging, messaging on long compute tasks or
general information sharing.
}
\details{
By default, everyting but \code{expr} will be looked for in a "\code{SLACK_}"
environment variable. You can override or just specify these values directly instead,
but it's probably better to call \link{slackrSetup} first.
}
\note{
You need a \url{slack.com} account and will also need to setup an API token \url{https://api.slack.com/}
}
\examples{
\dontrun{
slackrSetup()
slackr("iris info", head(iris), str(iris))
}
}
\seealso{
\code{\link{slackrSetup}}, \code{\link{slackrBot}}, \code{\link{dev.slackr}}, \code{\link{save.slackr}}, \code{\link{slackrUpload}}
}

