% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklarsomega.R
\name{check.colnames}
\alias{check.colnames}
\title{Check the column names of a Sklar's Omega data matrix for correctness.}
\usage{
check.colnames(data)
}
\arguments{
\item{data}{a matrix of scores. Each row corresponds to a unit, each column a coder.}
}
\value{
\code{check.colnames} returns a list comprising two elements.
        \item{success}{logical; if TRUE, the column names passed the test.}
        \item{cols}{if \code{success} is FALSE, vector \code{cols} contains the numbers of the problematic column names.}
}
\description{
Check the column names of a Sklar's Omega data matrix for correctness.
}
\details{
This function performs a somewhat rudimentary validation of the column names. At most one column may be labeled 'g', and said column must be the first. The only other valid format is 'c.C.S', where 'C' denotes coder number and 'S' denotes the Sth score for coder C (both positive whole numbers). It is up to the user to ensure that the coder and score indices make sense and are ordered correctly, i.e., coders, and scores for a given coder, are numbered consecutively.
}
\examples{
# The following data were presented in Krippendorff (2013).

data.nom = matrix(c(1,2,3,3,2,1,4,1,2,NA,NA,NA,
                    1,2,3,3,2,2,4,1,2,5,NA,3,
                    NA,3,3,3,2,3,4,2,2,5,1,NA,
                    1,2,3,3,2,4,4,1,2,5,1,NA), 12, 4)
colnames(data.nom) = c("c.1.1", "c.2.1", "c.3.1", "c.4.1")
data.nom
(check.colnames(data.nom))

# Introduce errors for columns 1 and 4.

colnames(data.nom) = c("c.a.1", "c.2.1", "c.3.1", "C.4.1")
(check.colnames(data.nom))

# The following scenario passes the check but is illogical.

colnames(data.nom) = c("g", "c.2.1", "c.1.47", "c.2.1")
(check.colnames(data.nom))
}
\references{
Krippendorff, K. (2013). Computing Krippendorff's alpha-reliability. Technical report, University of Pennsylvania.
}
