% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simonoff_tsai.R
\name{simonoff_tsai}
\alias{simonoff_tsai}
\title{Simonoff-Tsai Tests for Heteroskedasticity in a Linear Regression Model}
\usage{
simonoff_tsai(
  mainlm,
  auxdesign = NA,
  method = c("mlr", "score"),
  hetfun = c("mult", "add", "logmult"),
  basetest = c("koenker", "cook_weisberg"),
  bartlett = TRUE,
  optmethod = "Nelder-Mead",
  statonly = FALSE,
  ...
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{auxdesign}{A \code{\link[base]{data.frame}} or
\code{\link[base]{matrix}} representing an auxiliary design matrix of
containing exogenous variables that (under alternative hypothesis) are
related to error variance, or a character "fitted.values" indicating
that the fitted \eqn{\hat{y}_i} values from OLS should be used.
If set to \code{NA} (the default), the
design matrix of the original regression model is used. An intercept
is included in the auxiliary regression even if the first column of
\code{auxdesign} is not a vector of ones.}

\item{method}{A character specifying which of the tests proposed in
\insertCite{Simonoff94;textual}{skedastic} to implement. \code{"mlr"}
corresponds to the modified profile likelihood ratio test, and
\code{"score"} corresponds to the score test.}

\item{hetfun}{A character describing the form of \eqn{w(\cdot)}, the error
variance function under the heteroskedastic alternative. Possible values
are \code{"mult"} (the default), corresponding to
\eqn{w(Z_i,\lambda)=\exp\left\{\sum_{j=1}^{q}\lambda_j Z_{ij}\right\}},
\code{"add"}, corresponding to
\eqn{w(Z_i,\lambda)=\left(1+\sum_{j=1}^{q} \lambda_j Z_{ij}\right)^2}, and
\code{"logmult"}, corresponding to
\eqn{w(Z_i,\lambda)=\exp\left\{\sum_{j=1}^{q}\lambda_j \log Z_{ij}\right\}}.
The multiplicative and log-multiplicative cases are considered in
\insertCite{Cook83;textual}{skedastic}; the additive case is discussed,
\emph{inter alia}, by \insertCite{Griffiths86;textual}{skedastic}.
Results for the additive and multiplicative models are identical for this
test. Partial matching is used.}

\item{basetest}{A character specifying the base test statistic which is
robustified using the added term described in Details. \code{"koenker"}
corresponds to the test statistic produced by \code{\link{breusch_pagan}}
with argument \code{koenker} set to \code{TRUE}, while
\code{"cook_weisberg"} corresponds to the test statistic produced by
\code{\link{cook_weisberg}}. Partial matching is used. This argument is
only used if \code{method} is \code{"score"}.}

\item{bartlett}{A logical specifying whether a Bartlett correction should be
made, as per \insertCite{Ferrari04;textual}{skedastic}, to improve the
fit of the test statistic to the asymptotic null distribution. This
argument is only applicable where \code{method} is \code{"mlr"}, and is
implemented only where \code{hetfun} is \code{"mult"} or
\code{"logmult"}.}

\item{optmethod}{A character specifying the optimisation method to use with
\code{\link[stats]{optim}}, if \code{method} is \code{"mlr"}. The
default, \code{"Nelder-Mead"}, corresponds to the default \code{method}
value in \code{\link[stats]{optim}}. Warnings about Nelder-Mead algorithm
being unreliable for one-dimensional optimization have been suppressed,
since the algorithm does appear to work for the three implemented choices
of \code{hetfun}.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}

\item{...}{Optional arguments to pass to \code{\link[stats]{optim}}, such as
\code{par} (initial value of \eqn{\lambda}) and \code{maxit} (maximum
number of iterations to use in optimisation algorithm), and \code{trace}
(to provide detailed output on optimisation algorithm). Default initial
value of \eqn{\lambda} is \code{rep(1e-3, q)}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the modified profile likelihood ratio test and
   score test of \insertCite{Simonoff94;textual}{skedastic} for testing
   for heteroskedasticity in a linear regression model.
}
\details{
The Simonoff-Tsai Likelihood Ratio Test involves a modification of
   the profile likelihood function so that the nuisance parameter will be
   orthogonal to the parameter of interest. The maximum likelihood estimate
   of \eqn{\lambda} (called \eqn{\delta} in
   \insertCite{Simonoff94;textual}{skedastic}) is computed from the modified
   profile log-likelihood function using the Nelder-Mead algorithm in
   \code{\link[stats]{optim}}. Under the null hypothesis of
   homoskedasticity, the distribution of the test statistic is
   asymptotically chi-squared with \eqn{q} degrees of freedom. The test is
   right-tailed.

The Simonoff-Tsai Score Test entails adding a term to either the score
   statistic of \insertCite{Cook83;textual}{skedastic} (a test implemented
   in \code{\link{cook_weisberg}}) or to that of
   \insertCite{Koenker81;textual}{skedastic} (a test implemented in
   \code{\link{breusch_pagan}} with argument \code{koenker} set to
   \code{TRUE}), in order to improve the robustness of these respective
   tests in the presence of non-normality. This test likewise has a test
   statistic that is asymptotically \eqn{\chi^2(q)}-distributed and the test
   is likewise right-tailed.

The assumption of underlying both tests is that
   \eqn{\mathrm{Cov}(\epsilon)=\omega W}, where \eqn{W} is
   an \eqn{n\times n} diagonal matrix with \eqn{i}th diagonal element
   \eqn{w_i=w(Z_i, \lambda)}. Here, \eqn{Z_i} is the \eqn{i}th row of an
   \eqn{n \times q} nonstochastic auxiliary design matrix \eqn{Z}. Note:
   \eqn{Z} as defined here does not have a column of ones, but is
   concatenated to a column of ones when used in an auxiliary regression.
   \eqn{\lambda} is a \eqn{q}-vector of unknown parameters, and
   \eqn{w(\cdot)} is a real-valued, twice-differentiable function having the
   property that there exists some \eqn{\lambda_0} for which
   \eqn{w(Z_i,\lambda_0)=0} for all \eqn{i=1,2,\ldots,n}. Thus, the null
   hypothesis of homoskedasticity may be expressed as
   \eqn{\lambda=\lambda_0}.

In the score test, the added term in the test statistic is of the form
   \deqn{\sum_{j=1}^{q} \left(\sum_{i=1}^{n} h_{ii} t_{ij}\right) \tau_j},
   where \eqn{t_{ij}} is the \eqn{(i,j)}th element of the Jacobian matrix
   \eqn{J} evaluated at \eqn{\lambda=\lambda_0}:
   \deqn{t_{ij}=\left.\frac{\partial w(Z_i, \lambda)}{\partial \lambda_j}\right|_{\lambda=\lambda_0}},
   and \eqn{\tau=(\bar{J}'\bar{J})^{-1}\bar{J}'d}, where \eqn{d} is the
   \eqn{n}-vector whose \eqn{i}th element is \eqn{e_i^2\bar{\omega}^{-1}},
   \eqn{\bar{\omega}=n^{-1}e'e}, and \eqn{\bar{J}=(I_n-1_n 1_n'/n)J}.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
simonoff_tsai(mtcars_lm, method = "score")
simonoff_tsai(mtcars_lm, method = "score", basetest = "cook_weisberg")
simonoff_tsai(mtcars_lm, method = "mlr")
simonoff_tsai(mtcars_lm, method = "mlr", bartlett = FALSE)
\dontrun{simonoff_tsai(mtcars_lm, auxdesign = data.frame(mtcars$wt, mtcars$qsec),
 method = "mlr", hetfun = "logmult")}

}
\references{
{\insertAllCited{}}
}
