% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std.R
\name{std}
\alias{std}
\alias{center}
\title{Standardize and center variables}
\usage{
std(data, ..., include.fac = TRUE, append = FALSE)

center(data, ..., include.fac = TRUE, append = FALSE)
}
\arguments{
\item{data}{A variable that should be standardized or centered, or a
data frame with such variables.}

\item{...}{Optional, names of the variables with that should be standardized
or centered. Required, if either \code{data} is a data frame and no vector,
and only selected variables from \code{data} should be used
in the function.}

\item{include.fac}{Logical, if \code{TRUE}, factors will be converted to numeric
vectors and also standardized or centered.}

\item{append}{Logical, if \code{TRUE} and \code{data} is a data frame, the
standardized or centered variables will be appended as new columns
to \code{data}. Variable (column) names will be the same, however,
standardized variables get the suffix \code{"_z"}, while centered
variables get the suffix \code{"_c"}.}
}
\value{
Either a vector with standardized or centered variables, if \code{data}
        was a vector; or a \code{\link[tibble]{tibble}} with standardized or
        centered variables, if \code{data} was a data frame. If \code{append = TRUE},
        standardized and centered variables are added as new columns to \code{data}.
}
\description{
\code{std()} computes a z-transformation (standardized and centered)
             on the input. \code{center()} centers the input.
}
\note{
\code{std()} and \code{center()} only return a vector, if \code{data} is
        a vector. If \code{data} is a data frame and only one variable is specified
        in the \code{...}-ellipses argument, both functions do return a
        data frame (see 'Examples').
}
\examples{
library(dplyr)
data(efc)
std(efc$c160age) \%>\% head()
std(efc, e17age, c160age) \%>\% head()
std(efc, e17age, c160age, append = TRUE) \%>\% head()

center(efc$c160age) \%>\% head()
center(efc, e17age, c160age) \%>\% head()
center(efc, e17age, c160age, append = TRUE) \%>\% head()

# NOTE!
std(efc$e17age) # returns a vector
std(efc, e17age) # returns a tibble

# works with mutate()
efc \%>\%
  select(e17age, neg_c_7) \%>\%
  mutate(age_std = std(e17age), burden = center(neg_c_7))

}
