% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequ_trends.R
\name{inequ_trend}
\alias{inequ_trend}
\title{Compute trends in status inequalities}
\usage{
inequ_trend(data, prev.low, prev.hi)
}
\arguments{
\item{data}{A data frame that the variables with prevalence rates for both low
and high status groups (see 'Examples').}

\item{prev.low}{The name of the variable with the prevalence rates for
the low status groups.}

\item{prev.hi}{The name of the variable with the prevalence rates for
the hi status groups.}
}
\value{
A data frame with the prevalence rates as well as the values for the
          proportional change in absolute (\code{rd}) and relative (\code{rr})
          ineqqualities.
}
\description{
This method computes the proportional change of absolute
             (rate differences) and relative (rate ratios) inequalities
             of prevalence rates for two different status groups, as proposed
             by Mackenbach et al. (2015).
}
\details{
Given the time trend of prevalence rates of an outcome for two status
         groups (e.g. the mortality rates for people with lower and higher
         socioeconomic status over 40 years), this function computes the
         proportional change of absolute and relative inequalities, expressed
         in changes in rate differences and rate ratios. The function implements
         the algorithm proposed by \emph{Mackenbach et al. 2015}.
}
\examples{
# This example reproduces Fig. 1 of Mackenbach et al. 2015, p.5

# 40 simulated time points, with an initial rate ratio of 2 and
# a rate difference of 100 (i.e. low status group starts with a
# prevalence rate of 200, the high status group with 100)

# annual decline of prevalence is 1\% for the low, and 3\% for the
# high status group

n <- 40
time <- seq(1, n, by = 1)
lo <- rep(200, times = n)
for (i in 2:n) lo[i] <- lo[i - 1] * .99

hi <- rep(100, times = n)
for (i in 2:n) hi[i] <- hi[i - 1] * .97

prev.data <- data.frame(lo, hi)

# print values
inequ_trend(prev.data, lo, hi)

# plot trends - here we see that the relative inequalities
# are increasing over time, while the absolute inequalities
# are first increasing as well, but later are decreasing
# (while rel. inequ. are still increasing)
plot(inequ_trend(prev.data, lo, hi))

}
\references{
Mackenbach JP, Martikainen P, Menvielle G, de Gelder R. 2015. The Arithmetic of Reducing Relative and Absolute Inequalities in Health: A Theoretical Analysis Illustrated with European Mortality Data. Journal of Epidemiology and Community Health 70(7): 730–36. \doi{10.1136/jech-2015-207018}
}
