% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{Generate nonparametric bootstrap replications}
\usage{
bootstrap(data, n, size)
}
\arguments{
\item{data}{A data frame.}

\item{n}{Number of bootstraps to be generated}

\item{size}{Optional, size of the bootstrap samples. May either be a number
between 1 and \code{nrow(data)} or a value between 0 and 1 to sample
a proportion of observations from \code{data} (see 'Examples').}
}
\value{
A \code{\link[tibble]{data_frame}} with one column: a list-variable
          \code{strap}, which contains the bootstrapped samples from \code{data}.
}
\description{
Generates \code{n} bootstrap samples of \code{data} and
             returns the bootstrapped data frames as list-variable.
}
\details{
By default, each bootstrap sample has the same number of observations
           as \code{data}. To generate bootstrap samples without resampling
           same observations (i.e. sampling without replacement), use
           \code{size} to get bootstrapped data with a specific number
           of observations. However, specifying the \code{size}-argument is much
           less memory-efficient than the bootstrap with replacement. Hence,
           it is recommended to ignore the \code{size}-argument, if it is
           not really needed.
}
\note{
This function applies nonparametric bootstrapping, i.e. the function
      draws samples with replacement.
}
\examples{
data(efc)
bs <- bootstrap(efc, 5)

# now run models for each bootstrapped sample
lapply(bs$strap, function(x) lm(neg_c_7 ~ e42dep + c161sex, data = x))

# generate bootstrap samples with 600 observations for each sample
bs <- bootstrap(efc, 5, 600)

# generate bootstrap samples with 70\% observations of the original sample size
bs <- bootstrap(efc, 5, .7)


}
\seealso{
\code{\link{boot_ci}} to calculate confidence intervals from
           bootstrap samples.
}

