% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_vars.R
\name{pred_vars}
\alias{pred_vars}
\alias{resp_var}
\alias{resp_val}
\alias{link_inverse}
\alias{model_frame}
\alias{var_names}
\title{Access information from model objects}
\usage{
pred_vars(x)

resp_var(x)

resp_val(x)

link_inverse(x)

model_frame(x, fe.only = TRUE)

var_names(x)
}
\arguments{
\item{x}{A fitted model; for \code{var_names()}, \code{x} may also be a
character vector.}

\item{fe.only}{Logical, if \code{TRUE} (default) and \code{x} is a mixed effects
model, returns the model frame for fixed effects only.}
}
\value{
For \code{pred_vars()} and \code{resp_var()}, the name(s) of the
   response or predictor variables from \code{x} as character vector.
   \code{resp_val()} returns the values from \code{x}'s response vector.
   \code{link_inverse()} returns, if known, the inverse link function from
   \code{x}; else \code{NULL} for those models where the inverse link function
   can't be identified. \code{model_frame()} is similar to \code{model.frame()},
   but should also work for model objects that don't have a S3-generic for
   \code{model.frame()}. \code{var_names()} returns the "cleaned" variable
   names, i.e. things like \code{s()} for splines or \code{log()} are
   removed.
}
\description{
Several functions to retrieve information from model objects,
   like variable names, link-inverse function, model frame etc.
}
\examples{
data(efc)
fit <- lm(neg_c_7 ~ e42dep + c161sex, data = efc)

pred_vars(fit)
resp_var(fit)
resp_val(fit)

link_inverse(fit)(2.3)

# example from ?stats::glm
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
outcome <- gl(3, 1, 9)
treatment <- gl(3, 3)
m <- glm(counts ~ outcome + treatment, family = poisson())

link_inverse(m)(.3)
# same as
exp(.3)

outcome <- as.numeric(outcome)
m <- glm(counts ~ log(outcome) + as.factor(treatment), family = poisson())
var_names(m)

}
