% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_na.R
\name{set_na}
\alias{set_na}
\alias{set_na<-}
\title{Replace specific values in vector with NA}
\usage{
set_na(x, value)

set_na(x) <- value
}
\arguments{
\item{x}{Variable (vector), \code{data.frame} or \code{list} of variables where new
missing values should be defined. If \code{x} is a \code{data.frame}, each
column is assumed to be a new variable, where missings should be defined.}

\item{value}{Numeric vector with values that should be replaced with a
\code{\link[haven]{tagged_na}}.
Thus, for each variable in \code{x}, \code{value} are replaced by
tagged \code{NA} values.}
}
\value{
\code{x}, where each value of \code{value} is replaced by an a tagged
          \code{NA}.
}
\description{
This function replaces specific values of a variable, data frame
               or list of variables with missings (\code{NA}).
}
\details{
\code{set_na} converts all values defined in \code{value} with
           a related tagged \code{NA} (see \code{\link[haven]{tagged_na}}).
           Tagged \code{NA}s work exactly like regular R missing values
           except that they store one additional byte of information: a tag,
           which is usually a letter ("a" to "z") or character number ("0" to "9").
           \cr \cr
           Furthermore, see 'Details' in \code{\link{get_na}}.
}
\note{
Value and variable label attributes (see, for instance, \code{\link{get_labels}}
        or \code{\link{set_labels}}) are preserved.
}
\examples{
# create random variable
dummy <- sample(1:8, 100, replace = TRUE)
# show value distribution
table(dummy)
# set value 1 and 8 as missings
dummy <- set_na(dummy, c(1, 8))
# show value distribution, including missings
table(dummy, useNA = "always")

# add named vector as further missing value
set_na(dummy, c("Refused" = 5))
# see different missing types
library(haven)
print_tagged_na(set_na(dummy, c("Refused" = 5)))


# create sample data frame
dummy <- data.frame(var1 = sample(1:8, 100, replace = TRUE),
                    var2 = sample(1:10, 100, replace = TRUE),
                    var3 = sample(1:6, 100, replace = TRUE))
# set value 2 and 4 as missings
library(dplyr)
dummy \%>\% set_na(c(2, 4)) \%>\% head()
dummy \%>\% set_na(c(2, 4)) \%>\% get_na()
dummy \%>\% set_na(c(2, 4)) \%>\% get_values()

# create list of variables
data(efc)
dummy <- list(efc$c82cop1, efc$c83cop2, efc$c84cop3)
# check original distribution of categories
lapply(dummy, table, useNA = "always")
# set 3 to NA
lapply(set_na(dummy, 3), table, useNA = "always")


}
\seealso{
\code{\link{replace_na}} to replace \code{\link{NA}}'s with specific
           values, \code{\link{rec}} for general recoding of variables and
           \code{\link{recode_to}} for re-shifting value ranges. See
           \code{\link{get_na}} to get values of missing values in
           labelled vectors.
}

