% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_df.R
\name{merge_df}
\alias{merge_df}
\title{Merge labelled data frames}
\usage{
merge_df(x1, x2, ..., id = NULL)
}
\arguments{
\item{x1}{First data frame to be merged.}

\item{x2}{Second data frame to be merged.}

\item{...}{More data frames to be merged.}

\item{id}{Optional name for ID column that will be created to indicate the
source data frames for appended rows.}
}
\value{
A full joined data frame.
}
\description{
Merges (full join) two (or more) data frames and preserve value and variable labels.
}
\details{
This function merges two data frames, where equal named columns
           will be joined together. This function is a convenient wrapper for
           \code{merge(x1, x2, all = TRUE)}, however, unlike base
           \code{\link{merge}}, this function preserves value and
           variable labels. If matching columns have different value
           label attributes, attributes from first data frame will be
           used. For more details on the join operation, see
           'Details' in \code{\link{merge}} on \code{all}-argument.
}
\examples{
library(dplyr)
data(efc)
x1 <- efc \%>\% select(1:5) \%>\% slice(1:10)
x2 <- efc \%>\% select(3:7) \%>\% slice(1:10)

mydf <- merge_df(x1, x2)
mydf
str(mydf)

\dontrun{
library(sjPlot)
view_df(mydf)}

x3 <- efc \%>\% select(5:9) \%>\% slice(1:10)
x4 <- efc \%>\% select(11:14) \%>\% slice(1:10)

mydf <- merge_df(x1, x2, x3, x4, id = "subsets")
mydf
str(mydf)

}

