% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_note.R
\name{get_note}
\alias{get_note}
\title{Retrieve notes (annotations) from labelled variables}
\usage{
get_note(x)
}
\arguments{
\item{x}{Variable (vector) with note-attribute.}
}
\value{
The the value of the \code{note}-attribute of \code{x}.
}
\description{
This function retrieves the value of the \code{note}-attribute
               of vectors.
}
\examples{
# create labelled factor, with missing flag
x <- labelled(c("M", "M", "F", "X", "N/A"),
              c(Male = "M", Female = "F",
                Refused = "X", "Not applicable" = "N/A"),
              c(FALSE, FALSE, TRUE, TRUE))

set_label(x) <- "A labelled vector with note"
set_note(x) <- "Test annotation."
get_note(x)
x

}

