% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{is_empty}
\alias{is_empty}
\title{Check whether string is empty}
\usage{
is_empty(x)
}
\arguments{
\item{x}{a string or character vector of length 1.}
}
\value{
Logical, \code{TRUE} if \code{x} is empty, \code{FALSE} otherwise.
}
\description{
This function checks whether a string or character vector (of
               length 1) is empty or not.
}
\note{
\code{NULL}- or \code{NA}-values are also considered as "empty" (see
        'Examples') and will return \code{TRUE}.
}
\examples{
x <- "test"
is_empty(x)

x <- ""
is_empty(x)

x <- NA
is_empty(x)

x <- NULL
is_empty(x)

# string is not empty
is_empty(" ")

# however, this trimmed string is
is_empty(trim(" "))
}

