% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{weight2}
\alias{weight2}
\title{Weight a variable}
\usage{
weight2(var, weights)
}
\arguments{
\item{var}{The (unweighted) variable}

\item{weights}{A vector with same length as \code{var}, which
         contains weight factors. Each value of \code{var} has a
         specific assigned weight in \code{weights}.}
}
\value{
The weighted \code{var}.
}
\description{
This function weights the variable \code{var} by
               a specific vector of \code{weights}. It's an
               alternative weight calculation to \code{\link{weight}},
               though \code{\link{weight}} usage is recommended.
               This function sums up all \code{weights} values of the associated
               categories of \code{var}, whereas the \code{\link{weight}} function
               uses a \code{\link{xtabs}} formula to weight cases. Thus, this function
               may return a vector of different length than \code{var}.
}
\note{
See 'Note' in \code{\link{weight}}
}
\examples{
v <- sample(1:4, 20, TRUE)
table(v)
w <- abs(rnorm(20))
table(weight2(v, w))
}
\seealso{
\code{\link{weight}}
}

