% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{mean_n}
\alias{mean_n}
\title{Compute row means with min amount of valid values}
\usage{
mean_n(dat, n)
}
\arguments{
\item{dat}{a \code{\link{data.frame}} with at least two columns, where row means are applied.}

\item{n}{the amount of valid values per row to calculate the row mean. If a row's amount of valid
         values is less than \code{n}, \code{\link{NA}} will be returned as row mean value.}
}
\value{
A vector with row mean values of \code{df} for those rows with at least \code{n}
          valid values. Else, \code{\link{NA}} is returned.
}
\description{
This function is similar to the SPSS \code{MEAN.n} function and computes
               row means from a \code{\link{data.frame}} or \code{\link{matrix}} if at least \code{n}
               values of a row are valid (and not \code{\link{NA}}).
}
\examples{
dat <- data.frame(c1 = c(1,2,NA,4),
                  c2 = c(NA,2,NA,5),
                  c3 = c(NA,4,NA,NA),
                  c4 = c(2,3,7,8))
mean_n(dat, 4) # 1 valid return value
mean_n(dat, 3) # 2 valid return values
mean_n(dat, 2)
mean_n(dat, 1) # all means are shown
}
\references{
\itemize{
             \item \href{http://candrea.ch/blog/compute-spss-like-mean-index-variables/}{candrea's blog}
             \item \href{http://r4stats.com/2014/09/03/adding-the-spss-mean-n-function-to-r/}{r4stats.com}
             }
}

