% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotGLME.R
\name{sjp.lmer}
\alias{sjp.lmer}
\title{Plot estimates, predictions or effects of linear mixed effects models}
\usage{
sjp.lmer(fit, type = "re", vars = NULL, ri.nr = NULL,
  group.estimates = NULL, remove.estimates = NULL, emph.grp = NULL,
  sample.n = NULL, poly.term = NULL, sort.est = NULL, title = NULL,
  legend.title = NULL, axis.labels = NULL, axis.title = NULL,
  geom.size = NULL, geom.colors = "Set1", show.values = TRUE,
  show.p = TRUE, show.ci = FALSE, show.legend = FALSE,
  show.loess = FALSE, show.loess.ci = FALSE, show.intercept = FALSE,
  string.interc = "(Intercept)", p.kr = TRUE, show.scatter = TRUE,
  point.alpha = 0.2, point.color = NULL, jitter.ci = FALSE,
  fade.ns = FALSE, axis.lim = NULL, digits = 2, vline.type = 2,
  vline.color = "grey70", facet.grid = TRUE, free.scale = FALSE,
  y.offset = 0.1, prnt.plot = TRUE, ...)
}
\arguments{
\item{fit}{a fitted model as returned by the \code{\link[lme4]{lmer}}-function.}

\item{type}{type of plot. Use one of following:
\describe{
  \item{\code{"re"}}{(default) for conditional modes of random effects as forest plot}
  \item{\code{"fe"}}{for estimates of fixed effects as forest plot}
  \item{\code{"fe.std"}}{for standardized estimates of fixed effects as forest plot}
  \item{\code{"fe.slope"}}{to plot regression lines (slopes) with confidence intervals for each single fixed effect, i.e. all fixed terms are extracted and each is plotted against the response variable (linear relationship between each fixed term and response)}
  \item{\code{"fe.resid"}}{to plot regression lines (slopes) with confidence intervals for each single fixed effect (against residuals), i.e. all fixed terms are extracted and each is plotted against the model residuals (linear relationship between each fixed term and residuals)}
  \item{\code{"fe.cor"}}{for correlation matrix of fixed effects}
  \item{\code{"re.qq"}}{for a QQ-plot of random effects (random effects quantiles against standard normal quantiles)}
  \item{\code{"ri.slope"}}{for fixed effects slopes depending on the random intercept.}
  \item{\code{"rs.ri"}}{for fitted regression lines indicating the random slope-intercept pairs. Use this to visualize the random parts of random slope-intercept (or repeated measure) models. When having too many groups, use \code{sample.n} argument.}
  \item{\code{"coef"}}{for joint (sum of) random and fixed effects coefficients for each explanatory variable for each level of each grouping factor as forest plot.}
  \item{\code{"pred"}}{to plot predicted values for the response, related to specific model predictors and conditioned on random effects. See 'Details'.}
  \item{\code{"pred.fe"}}{to plot predicted values for the response, related to specific model predictors and conditioned on fixed effects only. See 'Details'.}
  \item{\code{"eff"}}{to plot marginal effects of all fixed terms in \code{fit}. Note that interaction terms are excluded from this plot; use \code{\link{sjp.int}} to plot effects of interaction terms. See also 'Details' of \code{\link{sjp.lm}}.}
  \item{\code{"eff.ri"}}{to plot marginal effects of all fixed terms in \code{fit}, varying by the random intercepts.}
  \item{\code{"poly"}}{to plot predicted values (marginal effects) of polynomial terms in \code{fit}. Use \code{poly.term} to specify the polynomial term in the fitted model (see 'Examples' here and 'Details' of \code{\link{sjp.lm}}).}
  \item{\code{"ma"}}{to check model assumptions. Note that no further arguments except \code{fit} are relevant for this option. All other arguments are ignored.}
}}

\item{vars}{Numeric vector with column indices of selected variables or a character vector with
variable names of selected variables from the fitted model, which should be used to plot
- depending on \code{type} - estimates, fixed effects slopes or predicted values
(mean, probabilities, incidents rates, ...). See 'Examples'.}

\item{ri.nr}{Numeric vector. If \code{type = "re"} or \code{type = "ri.slope"},
and fitted model has more than one random intercept, \code{ri.nr} indicates
which random effects of which random intercept (or: which list elements
of \code{\link[lme4]{ranef}}) will be plotted. Default is \code{NULL},
so all random effects will be plotted.}

\item{group.estimates}{Numeric or character vector, indicating a group identifier for
each estimate. Dots and confidence intervals of estimates are coloured
according to their group association. See 'Examples'.}

\item{remove.estimates}{Character vector with coefficient names that indicate
which estimates should be removed from the plot.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{emph.grp}{Numeric vector with index numbers of grouping levels (from random effect).
If \code{type = "ri.slope"} and \code{facet.grid = FALSE},
an integrated plot of predicted probabilities of fixed effects resp. fixed
effects slopes for each grouping level is plotted. To better find
certain groups, use this argument to emphasize these groups in the plot.
See 'Examples'.}

\item{sample.n}{Numeric vector. only applies, if \code{type = "rs.ri"}. If
plot has many random intercepts (grouping levels), overplotting of
regression lines may occur. In this case, consider random sampling of
grouping levels. If \code{sample.n} is of length 1, a random sample
of \code{sample.n} observation is selected to plot random intercepts.
If \code{sample.n} is of length > 1, random effects indicated by
the values in \code{sample.n} are selected to plot random effects.
Use the latter option to always select a fixed, identical set of
random effects for plotting (useful when ecomparing multiple models).}

\item{poly.term}{name of a polynomial term in \code{fit} as string. Needs to be
specified, if \code{type = "poly"}, in order to plot marginal effects
for polynomial terms. See 'Examples'.}

\item{sort.est}{Determines in which way estimates are sorted in the plot:
\itemize{
  \item If \code{NULL} (default), no sorting is done and estimates are sorted in order of model coefficients.
  \item If \code{sort.est = "sort.all"}, estimates are re-sorted for each coefficient (only applies if \code{type = "re"} and \code{facet.grid = FALSE}), i.e. the estimates of the random effects for each predictor are sorted and plotted to an own plot.
  \item If \code{type = "fe"} or \code{type = "fe.std"}, \code{TRUE} will sort estimates
  \item If \code{type = "re"}, specify a predictor's / coefficient's name to sort estimates according to this coefficient.
  }
  See 'Examples'.}

\item{title}{Character vector with one or more labels that are used as plot title.}

\item{legend.title}{Character vector, used as title for the plot legend. Note that
only some plot types have legends (e.g. \code{type = "pred"} or when
grouping estimates with \code{group.estimates}).}

\item{axis.labels}{Character vector with labels for the model terms, used as axis labels.
For mixed models, should either be vector of fixed effects variable labels
(if \code{type = "fe"} or \code{type = "fe.std"}) or a vector of group (value)
labels from the random intercept's categories (if \code{type = "re"}).}

\item{axis.title}{Character vector of length one or two (depending on
the plot function and type), used as title(s) for the x and y axis.
If not specified, a default labelling  is chosen. To set multiple
axis titles (e.g. with \code{type = "eff"} for many predictors),
\code{axis.title} must be a character vector of same length of plots
that are printed. In this case, each plot gets an own axis title
(applying, for instance, to the y-axis for \code{type = "eff"}).
\strong{Note:} Some plot types do not support this argument. In such
cases, use the return value and add axis titles manually with
\code{\link[ggplot2]{labs}}, e.g.: \code{$plot.list[[1]] + labs(x = ...)}}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{geom.colors}{User defined color palette for geoms. If \code{group.estimates}
is \emph{not} specified, must either be vector with two color values or a specific
color palette code (see 'Details' in \code{\link{sjp.grpfrq}}). Else, if
\code{group.estimates} is specified, \code{geom.colors} must be a vector
of same length as groups. See 'Examples'.}

\item{show.values}{Logical, whether values should be plotted or not.}

\item{show.p}{Logical, adds significance levels to values, or value and
variable labels.}

\item{show.ci}{Logical, if \code{TRUE}, depending on \code{type}, a confidence
interval or region is added to the plot. For frequency plots, the
confidence interval for the relative frequencies are shown.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{show.loess}{logical, if \code{TRUE}, and depending on \code{type}, an
additional loess-smoothed line is plotted.}

\item{show.loess.ci}{logical, if \code{TRUE}, a confidence region for the loess-smoothed line
will be plotted. Default is \code{FALSE}. Only applies, if \code{show.loess = TRUE}
(and for \code{\link{sjp.lmer}}, only applies if \code{type = "fe.slope"}
or \code{type = "fe.resid"}).}

\item{show.intercept}{Logical, if \code{TRUE}, the intercept of the fitted model is also plotted.
Default is \code{FALSE}. For \code{glm}'s, please note that due to exponential
transformation of estimates, the intercept in some cases can not be calculated, thus the
function call is interrupted and no plot printed.}

\item{string.interc}{String, axis label of intercept estimate. Only applies,
if \code{show.intercept = TRUE} and \code{axis.labels} is not \code{NULL}.}

\item{p.kr}{logical, if \code{TRUE}, p-value estimation is based on conditional
F-tests with Kenward-Roger approximation for the df. Caution: Computation
may take very long time for large samples!}

\item{show.scatter}{Logical, if \code{TRUE} (default), adds a scatter plot of
data points to the plot. Only applies for slope-type or predictions plots.
For most plot types, dots are jittered to avoid overplotting, hence the
points don't reflect exact values in the data.}

\item{point.alpha}{Alpha value of point-geoms in the scatter plots. Only applies,
if \code{show.scatter = TRUE}.}

\item{point.color}{Color of of point-geoms in the scatter plots. Only applies,
if \code{show.scatter = TRUE}.}

\item{jitter.ci}{Logical, if \code{TRUE} and \code{show.ci = TRUE} and confidence
bands are displayed as error bars, adds jittering to lines and error bars
to avoid overlapping.}

\item{fade.ns}{Logical, if \code{TRUE}, non significant estimates will be printed in slightly faded colors.}

\item{axis.lim}{Numeric vector of length 2, defining the range of the plot axis.
Depending on plot type, may effect either x- or y-axis, or both.
For multiple plot outputs (e.g., from \code{type = "eff"} or
\code{type = "slope"} in \code{\link{sjp.glm}}), \code{axis.lim} may
also be a list of vectors of length 2, defining axis limits for each
plot (only if non-faceted).}

\item{digits}{Numeric, amount of digits after decimal point when rounding estimates and values.}

\item{vline.type}{Linetype of the vertical "zero point" line. Default is \code{2} (dashed line).}

\item{vline.color}{Color of the vertical "zero point" line. Default value is \code{"grey70"}.}

\item{facet.grid}{\code{TRUE} to arrange the lay out of of multiple plots
in a grid of an integrated single plot. This argument calls
\code{\link[ggplot2]{facet_wrap}} or \code{\link[ggplot2]{facet_grid}}
to arrange plots. Use \code{\link{plot_grid}} to plot multiple plot-objects
as an arranged grid with \code{\link[gridExtra]{grid.arrange}}.}

\item{free.scale}{Logical, if \code{TRUE} and \code{facet.grid = TRUE}, each facet grid
gets its own fitted scale. If \code{free.scale = FALSE}, each facet in
the grid has the same scale range.}

\item{y.offset}{numeric, offset for text labels when their alignment is adjusted
to the top/bottom of the geom (see \code{hjust} and \code{vjust}).}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}

\item{...}{Other arguments passed down to further functions. Currently, following
arguments are supported:
\describe{
  \item{\code{?effects::effect}}{
    Any arguments accepted by the \code{\link[effects]{effect}} resp.
    \code{\link[effects]{allEffects}} function, for \code{type = "eff"}.
  }
  \item{\code{width}}{The \code{width}-argument for error bars.}
  \item{\code{alpha}}{The \code{alpha}-argument for confidence bands.}
  \item{\code{level}}{The \code{level}-argument confidence bands.}
}}
}
\value{
(Insisibily) returns
         \itemize{
           \item the ggplot-object (\code{plot}), if \code{type = "fe"} or if \code{type = "re"} and \code{facet.grid = TRUE}). Multiple plots (\code{type = "re"} and if \code{facet.grid = FALSE}) are returned in the object \code{plot.list}.
           \item a list of ggplot-objects (\code{plot.list}). see \code{plot} for details.
           \item a data frame \code{data} with the data used to build the ggplot-object(s).
           }
}
\description{
By default, this function plots estimates (coefficients) with confidence
               intervalls of either fixed effects or random effects of linear mixed
               effects models (that have been fitted with the \code{\link[lme4]{lmer}}-function
               of the \pkg{lme4}-package). Furhermore, this function also plot
               predicted values or diagnostic plots.
}
\details{
\describe{
           \item{\code{type = "re"}}{plots the conditional modes of the random
           effects, inclduing predicion intervals. It basically does the same
           as \code{dotplot(ranef(fit, condVar = TRUE)[[i]])}, where \code{i}
           denotes the random effect index.}
           \item{\code{type = "fe.slope"}}{plots the linear relationship between
           each fixed effect and the response. The regression lines are \emph{not}
           based on the fitted model's fixed effects estimates (though they may
           be similar). This plot type just computes a simple linear model for
           each fixed effect and response. Hence, it's intended for checking
           model assumptions, i.e. if predictor and respone are in a linear relationship.
           You may use the \code{show.loess} argument to see whether the linear
           line differs from the best fitting line.}
           \item{\code{type = "fe.resid"}}{Similar to \code{type = "fe.slope"},
           this this type is intended for checking model assumptions. However,
           fitted values are plotted against the residuals instead of response.}
           \item{\code{type = "eff"}}{plots the adjusted (marginal) effects
           for each fixed effect, with all co-variates set to the mean, as
           returned by the \code{\link[effects]{allEffects}} function.
           You can pass further arguments down to \code{allEffects} for flexible
           function call via the \code{...}-argument.}
           \item{\code{type = "eff.ri"}}{plots the adjusted (marginal) effects
           for each fixed effect, with all co-variates set to the mean, varying
           by the random intercepts. This plot type basically does the same
           as \code{type = "ri.slope"}, except that the co-variates are not
           set to zero, but adjusted for. This plot type differs from \code{type = "ri.slope"}
           only in the adjusted y-axis-scale}
           \item{\code{type = "rs.ri"}}{plots regression lines for the random
           parts of the model, i.e. all random slopes for each random intercept.
           As the random intercepts describe the deviation from the global intercept,
           the regression lines are computed as global intercept + random intercept +
           random slope. In case of overplotting,
           use the \code{sample.n} argument to randomly sample a limited amount
           of groups.}
           \item{\code{type = "ri.slope"}}{plots regression lines for each fixed
           effect (slopes) within each random intercept. Lines are based on
           the fixed effects intercept, plus each random intercept and
           each specific fixed term's estimate. All other fixed effects are
           set to zero (i.e. ignored),
           which corresponds to \code{b0 + b0[r1-rn] + bi * xi)}
           (where \code{xi} is the estimate of fixed effects, \code{b0} is the intercept of
           the fixed effects and \code{b0[r1-rn]} are all random intercepts).}
           \item{\code{type = "coef"}}{forest plot of joint fixed and random
           effect coefficients, as retrieved by \code{\link[lme4]{coef.merMod}},
           it's simply \code{\link[lme4]{ranef} + \link[lme4]{fixef}}.}
           \item{\code{type = "pred"} or \code{type = "pred.fe"}}{predicted
           values for response, conditional on fixed effects only or on random
           intercept. It's calling
           \code{predict(fit, type = "response", re.form = NA)} resp.
           \code{predict(fit, type = "response", re.form = NULL)} to
           compute the values.
           This plot type requires the \code{vars} argument to select specific terms
           that should be used for the x-axis and - optional - as grouping factor.
           Hence, \code{vars} must be a character vector with the names of
           one or two model predictors. See 'Examples'.}
         }
}
\note{
Computation of p-values (if necessary and if \code{p.kr = TRUE}) are based
        on conditional F-tests with Kenward-Roger approximation for the df, using
        the \pkg{pbkrtest}-package. If \pkg{pbkrtest} is not available or
        \code{p.kr = FALSE}, computation of p-values is based
        on normal-distribution assumption, treating the t-statistics as Wald
        z-statistics. See 'Details' in \code{\link[sjstats]{p_value}}.
}
\examples{
# fit model
library(lme4)
fit <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

# simple plot
sjp.lmer(fit)

# plot fixed effects
sjp.lmer(fit, type = "fe")

# sort by predictor Days
sjp.lmer(fit, sort.est = "Days")

# plot each predictor as own plot
# sort each plot
sjp.lmer(fit, facet.grid = FALSE, sort.est = "sort.all")

library(sjmisc)
library(sjlabelled)
data(efc)
# prepare group variable
efc$grp = as.factor(efc$e15relat)
levels(x = efc$grp) <- get_labels(efc$e15relat)
# data frame for fitted model
mydf <- data.frame(neg_c_7 = as.numeric(efc$neg_c_7),
                   sex = as.factor(efc$c161sex),
                   c12hour = as.numeric(efc$c12hour),
                   barthel = as.numeric(efc$barthtot),
                   grp = efc$grp)
# fit lmer
fit <- lmer(neg_c_7 ~ sex + c12hour + barthel + (1|grp), data = mydf)

sjp.lmer(fit, type = "fe.std", sort.est = TRUE)

# highlight specific grouping levels, in this case we compare
# spouses, children and children-in-law
sjp.lmer(fit, type = "ri.slope", emph.grp = c(1, 2, 4), vars = "c12hour")

\dontrun{
# plotting polynomial terms
# check linear relation between predictors and response
sjp.lmer(fit, type = "fe.slope", show.loess = TRUE)

# "barthel" does not seem to be linear correlated to response
# try to find appropiate polynomial. Grey line (loess smoothed)
# indicates best fit. Looks like x^4 has the best fit,
# however, x^2 seems to be suitable according to p-values.
sjp.poly(fit, "barthel", 2:4, show.scatter = FALSE)

# fit new model
fit <- lmer(neg_c_7 ~ sex + c12hour + barthel +
            I(barthel^2) + (1|grp), data = mydf)

# plot marginal effects of polynomial term
sjp.lmer(fit, type = "poly", poly.term = "barthel")

# lme4 complaints about scale of polynomial term, so
# try centering this predictor
mydf$barthel_s <- sjmisc::std(mydf$barthel)

# re-fit model
fit_s <- lmer(neg_c_7 ~ sex + c12hour + barthel_s +
              I(barthel_s^2) + (1|grp), data = mydf)

# plot marginal effects of centered, scaled polynomial term
sjp.lmer(fit_s, type = "poly", poly.term = "barthel_s")

# scaling also improved p-values
sjt.lmer(fit, fit_s)

# plotting predicted values for response
# conditioned on random effects
sjp.lmer(fit, type = "pred", vars = "c12hour")

# grouped, for fixed effects only
sjp.lmer(fit, type = "pred.fe", vars = c("c12hour", "sex"))

# grouped, for fixed effects only, non-facted
sjp.lmer(fit, type = "pred.fe", vars = c("c12hour", "sex"),
         facet.grid = FALSE, show.ci = FALSE)}

}
\seealso{
\href{http://www.strengejacke.de/sjPlot/sjp.lmer/}{sjPlot manual: sjp.lmer}
}
