% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sjt.pca}
\alias{sjt.pca}
\title{Show principal component analysis as HTML table}
\usage{
sjt.pca(data, numberOfFactors = NULL, factorLoadingTolerance = 0.1,
  file = NULL, varlabels = NULL,
  title = "Principal Component Analysis (with varimax rotation)",
  breakLabelsAt = 40, digits = 2, showCronbachsAlpha = TRUE,
  showMSA = FALSE, showVariance = FALSE, alternateRowColors = FALSE,
  stringPov = "Proportion of Variance",
  stringCpov = "Cumulative Proportion", encoding = "UTF-8", CSS = NULL,
  useViewer = TRUE, no.output = FALSE)
}
\arguments{
\item{data}{A data frame with factors (each columns one variable) that should be used
to compute a PCA, or a \code{\link{prcomp}} object.}

\item{numberOfFactors}{A predefined number of factors to use for the calculating the varimax
rotation. By default, this value is \code{NULL} and the amount of factors is
calculated according to the Kaiser-criteria. See paramater \code{plotEigenvalues}.}

\item{factorLoadingTolerance}{Specifies the minimum difference a variable needs to have between
factor loadings (components) in order to indicate a clear loading on just one factor and not
diffusing over all factors. For instance, a variable with 0.8, 0.82 and 0.84 factor loading
on 3 possible factors can not be clearly assigned to just one factor and thus would be removed
from the principal component analysis. By default, the minimum difference of loading values
between the highest and 2nd highest factor should be 0.1}

\item{file}{The destination file, which will be in html-format. If no filepath is specified,
the file will be saved as temporary file and openend either in the RStudio View pane or
in the default web browser.}

\item{varlabels}{The item labels that are printed in the first column. If no item labels are
provided (default), the data frame's column names are used. Item labels must
be a string vector, e.g.: \code{varlabels=c("Var 1", "Var 2", "Var 3")}.}

\item{title}{A table caption. By default, \code{"Principal Component Analysis (with varimax rotation)"}
is used as the table's title.}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the variable labels are displayed in
one line and when a line break is inserted. Default is 20.}

\item{digits}{The amount of digits used the values inside table cells.
Default is 2.}

\item{showCronbachsAlpha}{If \code{TRUE} (default), the cronbach's alpha value for each factor scale will be calculated,
i.e. all variables with the highest loading for a factor are taken for the
reliability test. The result is an alpha value for each factor dimension.
Only applies when \code{data} is a data frame and no \code{\link{prcomp}} object.}

\item{showMSA}{If \code{TRUE}, shows an additional column with the measure of sampling adequacy according
dor each component.}

\item{showVariance}{If \code{TRUE}, the proportions of variances for each component as well as cumulative
variance are shown in the table footer.}

\item{alternateRowColors}{If \code{TRUE}, alternating rows are highlighted with a light gray
background color.}

\item{stringPov}{The string for the table row that contains the proportions of variances. By default,
\code{"Proportion of Variance"} will be used.}

\item{stringCpov}{The string for the table row that contains the cumulative variances. By default,
\code{"Cumulative Proportion"} will be used.}

\item{encoding}{The charset encoding used for variable and value labels. Default is \code{"UTF-8"}. Change
encoding if specific chars are not properly displayed (e.g.) German umlauts).}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions, according to the official CSS syntax (see
\url{http://www.w3.org/Style/CSS/}). See return value \code{page.style} for details
of all style-sheet-classnames that are used in this function. Parameters for this list need:
\enumerate{
  \item the class-names with \code{"css."}-prefix as parameter name and
  \item each style-definition must end with a semicolon
}
You can add style information to the default styles by using a + (plus-sign) as
initial character for the parameter attributes. Examples:
\itemize{
  \item \code{css.table='border:2px solid red;'} for a solid 2-pixel table border in red.
  \item \code{css.summary='font-weight:bold;'} for a bold fontweight in the summary row.
  \item \code{css.lasttablerow='border-bottom: 1px dotted blue;'} for a blue dotted border of the last table row.
  \item \code{css.cronbach='+color:green;'} to add green color formatting to the Cronbach's Alpha value.
}
See further examples below and \url{http://rpubs.com/sjPlot/sjtbasics}.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{If \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}
}
\value{
Invisibly returns a \code{\link{structure}} with
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}),
           \item the html-table with inline-css for use with knitr (\code{knitr}),
           \item the \code{factor.index}, i.e. the column index of each variable with the highest factor loading for each factor and
           \item the \code{removed.items}, i.e. which variables have been removed because they were outside of the \code{factorLoadingTolerance}'s range.
           }
           for further use.
}
\description{
Performes a principle component analysis on a data frame or matrix and
               displays the factor solution as HTML table, or saves them as file.
               \cr \cr In case a data frame is used as
               parameter, the Cronbach's Alpha value for each factor scale will be calculated,
               i.e. all variables with the highest loading for a factor are taken for the
               reliability test. The result is an alpha value for each factor dimension.
}
\note{
The HTML tables can either be saved as file and manually opened (specify parameter \code{file}) or
        they can be saved as temporary files and will be displayed in the RStudio Viewer pane (if working with RStudio)
        or opened with the default web browser. Displaying resp. opening a temporary file is the
        default behaviour (i.e. \code{file=NULL}). \cr \cr
        This PCA uses the \code{\link{prcomp}} function and the \code{\link{varimax}} rotation.
}
\examples{
# randomly create data frame with 7 items, each consisting of 4 categories
likert_4 <- data.frame(sample(1:4, 500, replace=TRUE, prob=c(0.2,0.3,0.1,0.4)),
                       sample(1:4, 500, replace=TRUE, prob=c(0.5,0.25,0.15,0.1)),
                       sample(1:4, 500, replace=TRUE, prob=c(0.4,0.15,0.25,0.2)),
                       sample(1:4, 500, replace=TRUE, prob=c(0.25,0.1,0.4,0.25)),
                       sample(1:4, 500, replace=TRUE, prob=c(0.1,0.4,0.4,0.1)),
                       sample(1:4, 500, replace=TRUE),
                       sample(1:4, 500, replace=TRUE, prob=c(0.35,0.25,0.15,0.25)))

# Create variable labels
colnames(likert_4) <- c("V1", "V2", "V3", "V4", "V5", "V6", "V7")

# show table
\dontrun{
sjt.pca(likert_4)}

# -------------------------------
# Data from the EUROFAMCARE sample dataset
# -------------------------------
data(efc)

# retrieve variable and value labels
varlabs <- sji.getVariableLabels(efc)

# recveive first item of COPE-index scale
start <- which(colnames(efc)=="c82cop1")
# recveive last item of COPE-index scale
end <- which(colnames(efc)=="c90cop9")

# create data frame with COPE-index scale
df <- as.data.frame(efc[,c(start:end)])
colnames(df) <- varlabs[c(start:end)]

\dontrun{
sjt.pca(df)}

# -------------------------------
# auto-detection of labels
# -------------------------------
efc <- sji.setVariableLabels(efc, varlabs)
\dontrun{
sjt.pca(efc[,c(start:end)])}
}
\references{
\itemize{
             \item \url{http://strengejacke.wordpress.com/sjplot-r-package/}
             \item \url{http://strengejacke.wordpress.com/2014/03/04/beautiful-table-outputs-in-r-part-2-rstats-sjplot/}
             }
}
\seealso{
\code{\link{sjp.pca}} \cr
         \code{\link{sju.reliability}} \cr
         \code{\link{sjt.itemanalysis}} \cr
         \code{\link{sju.cronbach}}
}

