% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sivs.R
\name{plot.sivs}
\alias{plot.sivs}
\title{A plotting function for sivs object}
\usage{
\method{plot}{sivs}(
  x,
  type = c("frequency", "coef", "rfe"),
  suggestion_strictness = c(0.01, 0.05),
  ...
)
}
\arguments{
\item{x}{The object that is produced by the sivs function.}

\item{type}{Which plot do you want to have. Acceptable values are "frequency", "coef", and "rfe".}

\item{suggestion_strictness}{The strictness value that indicates how much the thresholds should be strict. For more details visit help page of `suggest()` function. If you want ru suppress the suggestion on the plot, set this to NULL.}

\item{...}{The other argument you might want to pass to each plot.}
}
\value{
Does not return anything. This function is only used for plotting
and is not meant to return any value.
}
\description{
A function to plot the object of the sivs function.
}
\details{
The rfe plot ignores the existance of intercept since intercept
cannot be removed in the recursive feature elimination step. This
is the reason that the number of features with vimp greater than 0
are differnt from the presented "Number of Features Left" in the
rfe plot by 1.
}
\examples{
\dontrun{
# to see all plots
layout(mat = matrix(c(1,2,3,3), nrow = 2, byrow = TRUE))
plot(x = sivs_object)
layout(1)

# to plot only the Recursive Feature Elimination (rfe) results
plot(x = sivs_object, type = "rfe")

# suppress suggestion on rfe plot
plot(x = sivs_object, type = "rfe", suggestion_strictness = NULL)
}

## WORKING EXAMPLE
## Note that this example does not logically make sense as iris data has only
## 4 columns and there is no need for SIVS to take care of feature selection
## therefore this example is only here for testing purposes.

tmp <- subset(x = iris, subset = Species != "setosa")

tmp <- varhandle::unfactor(tmp)

sivs_obj <- sivs(x = tmp[, c("Sepal.Length", "Sepal.Width",
                             "Petal.Length", "Petal.Width")],
                 y = factor(tmp$Species),
                 family = "binomial",
                 verbose = "detailed",
                 progressbar = FALSE,
                 nfolds = 3,
                 parallel.cores = FALSE,
                 iter.count = 20)
plot(sivs_obj, type = "frequency")
plot(sivs_obj, type = "coef")
plot(sivs_obj, type = "rfe")


}
