% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sitsfeats-package.R
\docType{package}
\name{sitsfeats}
\alias{sitsfeats}
\alias{sitsfeats-package}
\title{R package for extracting metrics from time series of satellite images}
\description{
Provides a set of temporal metrics derived from satellite image time series.
    The basics metrics are composed of basic statistics, histogram-based statistics, and methods 
    based on time series analysis.
    The polar metrics, an approach proposed by Korting et al. (2013) <doi:10.1016/j.cageo.2013.02.007>, 
    is based on the polar representation to describe cyclic events, whose events are common in agricultural applications.
}
\section{The \code{sitsfeats} functions}{

The sitsfeats package provides two type of metrics:
\itemize{
  \item \code{basics}: The basic metrics provide basic statistical functions,
   such as mean, median.
  \item \code{polar}: Polar metrics provide functions based on polar
  coordinates, implemented by
  Korting, T. S., Fonseca, L. M. G., & Câmara, G. (2013).
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/oldlipe/sitsfeats/}
  \item Report bugs at \url{https://github.com/oldlipe/sitsfeats/issues}
}

}
\author{
\strong{Maintainer}: Felipe Carvalho \email{lipecaso@gmail.com}

Authors:
\itemize{
  \item Karine Ferreira \email{karine.ferreira@inpe.br}
  \item Rafael Santos \email{rafael.santos@inpe.br}
}

}
