% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_csv.R
\name{sits_to_csv}
\alias{sits_to_csv}
\alias{sits_to_csv.sits}
\alias{sits_to_csv.tbl_df}
\alias{sits_to_csv.default}
\title{Export a sits tibble metadata to the CSV format}
\usage{
sits_to_csv(data, file)

\method{sits_to_csv}{sits}(data, file)

\method{sits_to_csv}{tbl_df}(data, file)

\method{sits_to_csv}{default}(data, file)
}
\arguments{
\item{data}{Time series (tibble of class "sits").}

\item{file}{Full path of the exported CSV file
(valid file name with extension ".csv").}
}
\value{
Called for side effects
}
\description{
Converts metadata from a sits tibble to a CSV file.
             The CSV file will not contain the actual time
             series. Its columns will be the same as those of a
             CSV file used to retrieve data from
             ground information ("latitude", "longitude", "start_date",
             "end_date", "cube", "label").
}
\examples{
csv_file <- paste0(tempdir(), "/cerrado_2classes.csv")
sits_to_csv(cerrado_2classes, file = csv_file)
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
