% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_torch_temporal_attention_encoder.R
\name{.torch_light_temporal_attention_encoder}
\alias{.torch_light_temporal_attention_encoder}
\title{Torch module for temporal attention encoder}
\usage{
.torch_light_temporal_attention_encoder(
  timeline,
  in_channels = 128,
  n_heads = 16,
  n_neurons = c(256, 128),
  dropout_rate = 0.2
)
}
\arguments{
\item{timeline}{Timeline of input time series.}

\item{in_channels}{Dimension of the positional encoder.}

\item{n_heads}{Number of attention heads.}

\item{n_neurons}{Dimensions of MLP that processes the
output of the attention heads.}

\item{dropout_rate}{Dropout_rate.}
}
\value{
A linear tensor block.

for Classifying Satellite Image Time Series"
}
\description{
Defines a torch module for temporal attention encoding.

This implementation is based on the code made available by Vivien Garnot
https://github.com/VSainteuf/lightweight-temporal-attention-pytorch
}
\references{
Vivien Sainte Fare Garnot and Loic Landrieu,
"Lightweight Temporal Self-Attention for Classifying Satellite Image
Time Series", https://arxiv.org/abs/2007.00586
}
\author{
Charlotte Pelletier, \email{charlotte.pelletier@univ-ubs.fr}

Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Souza, \email{lipecaso@gmail.com}
}
\keyword{internal}
