% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_timeline.R
\name{.sits_timeline_class_info}
\alias{.sits_timeline_class_info}
\title{Define the information required for classifying time series}
\usage{
.sits_timeline_class_info(data, samples)
}
\arguments{
\item{data}{Description on the data being classified.}

\item{samples}{Samples used for training the classification model.}
}
\value{
A tibble with the classification information.
}
\description{
Time series classification requires a series of steps:
(a) Provide labelled samples that will be used as training data.
(b) Provide information on how the classification will be performed,
    including data timeline,and start and end dates per interval.
(c) Clean the training data to ensure it meets the specifications
    of the classification info.
(d) Use the clean data to train a machine learning classifier.
(e) Classify non-labelled data sets.

In this set of steps, this function provides support for step (b).
It requires the user to provide a timeline, the classification interval,
and the start and end dates of the reference period. T
he results is a tibble with information that allows the user
to perform steps (c) to (e).
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
\keyword{internal}
