% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS2z.R
\name{LMS2z}
\alias{LMS2z}
\title{Convert to/from measurement from/to z-score with growth reference}
\usage{
LMS2z(x, y, sex, measure, ref, toz = TRUE, verbose = FALSE)
}
\arguments{
\item{x}{vector of ages.}

\item{y}{vector of either measurements or z-scores, depending on the value
of \code{toz}.}

\item{sex}{factor where males = 1 and females = 2.}

\item{measure}{measurement, either as name or character string, the choice
depending on the choice of \code{ref} (see e.g. references \code{uk90},
\code{who06} and \code{ukwhopt}).}

\item{ref}{growth reference, either as name or character string, available
as a \code{data} object or data frame.}

\item{toz}{logical set to TRUE for conversion from measurement to z-score,
or FALSE for the reverse.}

\item{verbose}{logical set to TRUE to print the associated LMS table.}
}
\value{
A vector or matrix, depending on the lengths of \code{x} and
\code{y}, containing the transformed values. If the two lengths are the
same, or either is one, then a vector is returned. If they are different and
not one, then a matrix with \code{length(x)} rows and \code{length(y)}
columns is returned. In this latter case the row names are set to \code{x},
and if \code{toz} is false the column names are set using \code{z2cent}.
}
\description{
A function to convert between measurements and z-scores using a growth
reference previously fitted by the LMS method.
}
\details{
Vectors of L, M and S corresponding to \code{x} and \code{sex} are extracted
and passed to either \code{\link{cLMS}} or \code{\link{zLMS}}, depending on
\code{toz}.
}
\examples{

## convert girls' heights data to UK 90 z-scores
data(heights)
data(uk90)
with(heights, LMS2z(age, height, sex = 2, measure = 'ht', ref = 'uk90'))

## construct table of boys weight centiles by age for WHO standard
data(who06)
zs <- -4:4*2/3 # z-scores for centiles
ages <- 0:12/4 # 3-month ages
v <- vapply(as.list(zs), function(z)
 LMS2z(ages, z, sex = 1, measure = wt, ref = who06, toz = FALSE),
  rep(0, length(ages)))
dimnames(v) <- list(ages, z2cent(zs))
round(v, 2)

}
\seealso{
\code{\link{z2cent}}. The LMS method can be fitted to data using
the package \code{gamlss} with the \code{BCCG} family, where nu (originally
lambda), mu and sigma correspond to L, M and S respectively.
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
\keyword{arith}
