% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{sampleLibrarySize}
\alias{sampleLibrarySize}
\title{Samples the expected library size of individuals/samples}
\usage{
sampleLibrarySize(samples_list, meanLogLibSize_lane = 7,
  sdLogLibSize_lane = 0.5, sdLogLibSize_samples = 0.2,
  laneEffect = F, nLanes = 2)
}
\arguments{
\item{samples_list}{List of sample/individual names.}

\item{meanLogLibSize_lane}{Numeric. The mean of the log10 mean library size normal distribution (see Details). Default value of 7.}

\item{sdLogLibSize_lane}{Numeric. The sd of the log10 mean library size normal distribution (see Details). Default value of 0.5.}

\item{sdLogLibSize_samples}{Numeric. The sd of the log10 samples library size normal distribution (see Details). Default value of 0.2.}

\item{laneEffect}{Boolean. Are the samples processed on different lanes/batches? Default value is FALSE.}

\item{nLanes}{Numeric. How many lanes are there in the experiment? Automatically set to 1 if \code{laneEffect = F}. Default value is 2.}
}
\value{
A list:
\itemize{
\item \code{lane}: the lane on which each sample is processed.
\item \code{expected_library_size}: the expected library size of each sample.
\item \code{lane_mean_library_size}: the mean library size of each lane.
}
}
\description{
Samples the expected library size of each individual/sample, accounting for potential lane size effects
(i.e. the impact of samples being processed on different lanes).
}
\details{
The expected library size of each individual is sampled from a log-normal distribution. The mean of this distribution
depends on the lane on which the individual/sample is processed. By default, when \code{laneEffect = FALSE}, all samples
are assumed to be processed in a single batch. Thus their library size is sampled from a log-normal distribution with
identical mean (equal to \code{meanLogLibSize_lane}) and sd \code{sdLogLibSize_samples}. If \code{laneEffect = TRUE}, the
samples are assumed to be processed in \code{nLanes} batches, that each have a different mean log-library size. In this
case, the mean of the log-normal distribution for each lane is sampled from a normal distribution with mean
\code{meanLogLibSize_lane} and sd \code{sdLogLibSize_lane}. In turn, the expected library size of each individual/sample
is sampled form a log-normal distribution with the corresponding lane-dependent mean, and sd \code{sdLogLibSize_samples}.
}
\examples{
samples_list = sapply(1:10, function(x){paste0("Ind", x)})
libsize = sampleLibrarySize(samples_list)
libsize = sampleLibrarySize(samples_list, laneEffect = TRUE, nLanes = 3)
}
